/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.traceanalyser;

import java.util.ArrayList;
import org.polarsys.chess.monitoring.traceanalyser.Event;

public class ThreadEvents {
    private String threadID;
    private ArrayList<Event> runningEvents;
    private ArrayList<Event> readyEvents;
    private ArrayList<Event> blockedEvents;
    private ArrayList<Event> sleepEvents;
    private ArrayList<Event> wakeupEvents;

    public ThreadEvents(String inThreadID, ArrayList<Event> inThreadEvents) {
        this.threadID = inThreadID;
        this.runningEvents = new ArrayList();
        this.readyEvents = new ArrayList();
        this.blockedEvents = new ArrayList();
        this.sleepEvents = new ArrayList();
        this.wakeupEvents = new ArrayList();
        for (Event event : inThreadEvents) {
            if (event.GetEventID() == 0) {
                this.runningEvents.add(event);
                continue;
            }
            if (event.GetEventID() == 1) {
                this.readyEvents.add(event);
                continue;
            }
            if (event.GetEventID() == 2) {
                this.blockedEvents.add(event);
                continue;
            }
            if (event.GetEventID() == 3) {
                this.sleepEvents.add(event);
                continue;
            }
            if (event.GetEventID() == 4) {
                this.wakeupEvents.add(event);
                continue;
            }
            System.out.println("Invalid event ID in " + event);
        }
    }

    public ArrayList<Event> GetRunningEvents() {
        return this.runningEvents;
    }

    public ArrayList<Event> GetReadyEvents() {
        return this.readyEvents;
    }

    public ArrayList<Event> GetBlockedEvents() {
        return this.blockedEvents;
    }

    public ArrayList<Event> GetSleepEvents() {
        return this.sleepEvents;
    }

    public ArrayList<Event> GetWakeupEvents() {
        return this.wakeupEvents;
    }

    public String GetThreadID() {
        return this.threadID;
    }

    public long GetFirstReadyEventInGivenInterval(long timeStart, long timeEnd) {
        for (Event event : this.readyEvents) {
            if (event.GetTimeStamp() >= timeStart && event.GetTimeStamp() <= timeEnd) {
                return event.GetTimeStamp();
            }
            if (event.GetTimeStamp() <= timeEnd) continue;
            return -1L;
        }
        return -1L;
    }

    public long GetFirstRunningEventInGivenInterval(long timeStart, long timeEnd) {
        for (Event event : this.runningEvents) {
            if (event.GetTimeStamp() >= timeStart && event.GetTimeStamp() <= timeEnd) {
                return event.GetTimeStamp();
            }
            if (event.GetTimeStamp() <= timeEnd) continue;
            return -1L;
        }
        return -1L;
    }

    public long GetLastSleepEventInGivenInterval(long timeStart, long timeEnd) {
        long prev = -1L;
        for (Event event : this.sleepEvents) {
            if (event.GetTimeStamp() >= timeStart && event.GetTimeStamp() <= timeEnd) {
                prev = event.GetTimeStamp();
                continue;
            }
            if (event.GetTimeStamp() > timeEnd) break;
        }
        return prev;
    }

    public long FindLastSleepIfAnyAvailable(long currentWakeupTime) {
        for (Event event : this.sleepEvents) {
            if (event.GetTimeStamp() < currentWakeupTime) continue;
            return event.GetTimeStamp();
        }
        return -1L;
    }
}

