/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.codegen.ada.handlers;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.chess.codegen.ada.transformations.Transformations;
import org.polarsys.chess.codegen.ada.util.AdaGenUtil;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;

public class AdaGenUIHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        AdaGenUIHandler.this.execute_(editor, monitor);
                    }
                    finally {
                        AdaGenUtil.getActiveProject(editor).refreshLocal(2, monitor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    CHESSProjectSupport.printlnToCHESSConsole((String)sw.toString());
                    return new Status(4, "org.polarsys.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    private void execute_(IEditorPart editor, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Transforming", 4);
        if (!(editor instanceof PapyrusMultiDiagramEditor)) {
            return;
        }
        PapyrusMultiDiagramEditor cEditor = (PapyrusMultiDiagramEditor)editor;
        Resource inResource = null;
        try {
            inResource = ResourceUtils.getUMLResource((ServicesRegistry)cEditor.getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new Exception("Unable to load the model");
        }
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        Transformations.performCodeGeneration((PapyrusMultiDiagramEditor)editor, inputFile, monitor);
    }
}

