/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import eu.fbk.eclipse.standardTools.XSapExecService.services.XSapExecService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.transformations.commands.CommandsCommon;
import org.polarsys.chess.contracts.transformations.dialogs.SelectFTAFMEAAnalysisCtxDialog;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.core.utils.FileNamesUtil;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.smvExporter.ui.services.CHESSSmvExporterService;

public abstract class AbstractXSapHandler
extends AbstractHandler {
    private String systemQN;
    private Shell activeShell;
    private List<String> args;
    private String smvFileName;
    private String feiFileName;
    private String expandedFeiFileName;
    protected String ftaFmeaCond;
    protected String modelName;
    protected IEditorPart editor;
    protected String extendedSmvFileName;
    protected String fmsFileName;
    protected AnalysisContextElement analysisContext;
    protected final FileNamesUtil fileNamesUtil = FileNamesUtil.getInstance();
    protected final XSapExecService xSapExecService = XSapExecService.getInstance();
    protected final AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();

    private boolean computeFileNames(ExecutionEvent event, Class systemComponent, InstantiatedArchitectureConfiguration instantiatedArchitecture, Analysis analysis) throws ExecutionException {
        String fileName;
        block4: {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            this.editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            this.activeShell = window.getShell();
            try {
                PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
                Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
                Model model = ResourceUtils.getModel((Resource)res);
                SelectFTAFMEAAnalysisCtxDialog dialog = new SelectFTAFMEAAnalysisCtxDialog(this.activeShell, systemComponent, instantiatedArchitecture, model, analysis);
                fileName = model.getName();
                dialog.create();
                if (dialog.open() == 0) {
                    this.systemQN = dialog.getSystem();
                    this.ftaFmeaCond = dialog.getFtaCondition();
                    this.analysisContext = dialog.getAnalysisContext();
                    if (this.systemQN == null || this.systemQN.isEmpty() || this.ftaFmeaCond == null || this.ftaFmeaCond.isEmpty()) {
                        return false;
                    }
                    break block4;
                }
                return false;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.args = new ArrayList<String>();
        this.args.add(this.systemQN);
        String systemName = this.systemQN.substring(this.systemQN.lastIndexOf("::") + 2);
        this.args.add(systemName);
        this.modelName = String.valueOf(fileName) + "_" + systemName;
        this.args.add(this.modelName);
        this.smvFileName = this.fileNamesUtil.computeSmvFileName(this.editor, this.modelName);
        this.feiFileName = this.fileNamesUtil.computeFeiFileName(this.editor, this.modelName);
        this.expandedFeiFileName = this.fileNamesUtil.computeExpandedFeiFileName(this.editor, this.modelName);
        this.extendedSmvFileName = this.fileNamesUtil.computeExtendedSmvFileName(this.editor, this.modelName);
        this.fmsFileName = this.fileNamesUtil.computeFmsFileName(this.editor, this.modelName);
        return true;
    }

    protected boolean prepareExpandedFiles(ExecutionEvent event, Class systemComponent, InstantiatedArchitectureConfiguration instantiatedArchitecture, Analysis analysis) throws ExecutionException {
        if (!this.computeFileNames(event, systemComponent, instantiatedArchitecture, analysis)) {
            return false;
        }
        CommandsCommon.TransformationJob(this.activeShell, this.editor, this.args, CommandsCommon.CommandEnum.FEI, null, this.ftaFmeaCond);
        CHESSSmvExporterService smvExporterService = CHESSSmvExporterService.getInstance();
        if (!smvExporterService.createMonolithicSmvFile(this.smvFileName)) {
            return false;
        }
        if (!this.xSapExecService.expandFaultExtensions(this.feiFileName, this.expandedFeiFileName, true)) {
            return false;
        }
        return this.xSapExecService.extendModel(this.smvFileName, this.expandedFeiFileName, this.fmsFileName, this.extendedSmvFileName, true);
    }
}

