/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;

public class SelectSystemDialog
extends Dialog {
    private static final String SYSTEM = "CHESSContract::System";
    private Combo chooseSystemField;
    private Model model;
    private String system;

    public SelectSystemDialog(Shell shell, Model model) {
        super(shell);
        this.model = model;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText("Systems found in model:");
        GridData gridData = new GridData(768);
        this.chooseSystemField = new Combo(parent, 12);
        for (Class sys : this.getSystems(this.model)) {
            this.chooseSystemField.add(sys.getQualifiedName());
        }
        this.chooseSystemField.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("");
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select System to analyze");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSystem(this.chooseSystemField.getText());
        super.okPressed();
    }

    public void setSystem(String qname) {
        this.system = qname;
    }

    public String getSystem() {
        return this.system;
    }

    private List<Class> getSystems(Model model) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (Element elem : model.allOwnedElements()) {
            if (elem.getAppliedStereotype(SYSTEM) == null) continue;
            result.add((Class)elem);
        }
        return result;
    }
}

