/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.faultTreeGenerator.handlers;

import eu.fbk.eclipse.standardtools.faultTreeViewer.utils.FaultTreeViewerUtil;
import java.io.File;
import javax.swing.JFileChooser;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.polarsys.chess.fla.faultTreeGenerator.handlers.Transformation;

public class FTAHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath pat = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        File folder = new File(pat.toOSString());
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(folder);
        chooser.setDialogTitle("Please select your FLA results file");
        chooser.setFileSelectionMode(2);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            IFile target;
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            String flaName = chooser.getSelectedFile().getName();
            String flaName2 = flaName.replaceAll(".flamm", "");
            File emfta = new File(chooser.getCurrentDirectory() + "/" + flaName2 + ".emfta");
            if (emfta.exists() && !emfta.isDirectory()) {
                MessageDialog.openError(null, (String)"Error in process", (String)"The selected folder already contains a result of the transformation. Please, remove the existing one or change the .emfta file name.");
                return null;
            }
            Transformation transformation = new Transformation(event);
            ProgressMonitorDialog nombrequequiera = new ProgressMonitorDialog(null);
            nombrequequiera.open();
            IProgressMonitor pMonitor = nombrequequiera.getProgressMonitor();
            pMonitor.beginTask("Generating FTA diagram. Please wait...", -1);
            IPath modelLocation = transformation.execute(chooser);
            if (modelLocation == null) {
                pMonitor.done();
                nombrequequiera.close();
            }
            if ((target = ResourcesPlugin.getWorkspace().getRoot().getFile(modelLocation)).getFileExtension().equals("emfta")) {
                IPath path2 = target.getFullPath();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path2);
                try {
                    try {
                        FaultTreeViewerUtil.getInstance().openFTAViewerFromEmftaFile(file, (IProgressMonitor)new NullProgressMonitor());
                        pMonitor.done();
                        nombrequequiera.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        pMonitor.done();
                        nombrequequiera.close();
                    }
                }
                finally {
                    pMonitor.done();
                    nombrequequiera.close();
                }
            } else {
                pMonitor.done();
                nombrequequiera.close();
                MessageDialog.openError(null, (String)"Error in process", (String)"The selected file is not the result of a Failure Logic Analysis. Please select a proper one.");
            }
        } else {
            System.out.println("No Selection ");
        }
        return null;
    }
}

