/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.InstanceSpecification;

public class SystemSelectionDialog
extends Dialog {
    private Combo chooseSystemField;
    private String selectedSystemName;
    private InstanceSpecification selectedSystem;
    private String title;
    private List<InstanceSpecification> systemsList;

    public SystemSelectionDialog(Shell parentShell, List<InstanceSpecification> systemSelection, String title) {
        super(parentShell);
        this.systemsList = systemSelection;
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText("Systems found in model: ");
        GridData gridData = new GridData(768);
        this.chooseSystemField = new Combo(parent, 12);
        for (InstanceSpecification theSystem : this.systemsList) {
            this.chooseSystemField.add(theSystem.getQualifiedName());
        }
        this.chooseSystemField.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("");
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSystemName(this.chooseSystemField.getText());
        super.okPressed();
    }

    public void setSystemName(String qname) {
        this.selectedSystemName = qname;
    }

    public String getSystemName() {
        return this.selectedSystemName;
    }

    public InstanceSpecification getSelectedSystem() {
        return this.selectedSystem;
    }

    public void setSelectedSystem(InstanceSpecification selectedSystem) {
        this.selectedSystem = selectedSystem;
    }
}

