/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.partitioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.polarsys.chess.multicore.partitioning.Bin;
import org.polarsys.chess.multicore.partitioning.BinPacker;
import org.polarsys.chess.multicore.partitioning.Task;

public class WorstFitBinPacker
implements BinPacker {
    private final boolean DECREASING_ORDERING = true;

    @Override
    public Map<Bin, List<Task>> pack(List<Bin> bins, List<Task> tasks) {
        Hashtable<Bin, List<Task>> toReturn = new Hashtable<Bin, List<Task>>();
        if (tasks.size() <= bins.size()) {
            int i = 0;
            for (Task task : tasks) {
                Bin bin = bins.get(i);
                ArrayList<Task> theList = new ArrayList<Task>();
                theList.add(task);
                bin.setCapacity(Float.valueOf(bin.getCapacity().floatValue() + task.getU().floatValue()));
                toReturn.put(bin, theList);
                ++i;
            }
        } else {
            Object[] allTasks = tasks.toArray();
            Arrays.sort(allTasks, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return -((Task)o1).getU().compareTo(((Task)o2).getU());
                }
            });
            int indexEmptiestBin = 0;
            float emptiestCapacity = 0.0f;
            Object[] allBins = new Object[]{new Bin(indexEmptiestBin)};
            int indexLastBin = 0;
            if (bins.size() > 0) {
                allBins = bins.toArray();
                indexLastBin = bins.size() - 1;
            }
            int taskIndex = 0;
            while (taskIndex < allTasks.length) {
                Task task = (Task)allTasks[taskIndex];
                Bin bin = (Bin)allBins[indexEmptiestBin];
                if (bin.getCapacity().floatValue() + task.getU().floatValue() <= bin.getSize().floatValue()) {
                    task.setOwner(bin);
                    bin.setCapacity(Float.valueOf(bin.getCapacity().floatValue() + task.getU().floatValue()));
                    ArrayList<Task> theTasks = (ArrayList<Task>)toReturn.get(bin);
                    if (theTasks == null) {
                        theTasks = new ArrayList<Task>();
                    }
                    theTasks.add(task);
                    toReturn.put(bin, theTasks);
                } else {
                    Bin newBin = new Bin(new Integer(++indexLastBin));
                    task.setOwner(newBin);
                    newBin.setCapacity(Float.valueOf(newBin.getCapacity().floatValue() + task.getU().floatValue()));
                    ArrayList<Task> theList = new ArrayList<Task>();
                    theList.add(task);
                    toReturn.put(newBin, theList);
                    Object[] tmpBinArray = Arrays.copyOf(allBins, allBins.length + 1);
                    assert (tmpBinArray.length - 1 == indexLastBin);
                    tmpBinArray[indexLastBin] = newBin;
                    allBins = tmpBinArray;
                }
                emptiestCapacity = Float.MAX_VALUE;
                int binIndex = 0;
                while (binIndex < allBins.length) {
                    float currentCapacity = ((Bin)allBins[binIndex]).getCapacity().floatValue();
                    if (currentCapacity < emptiestCapacity) {
                        emptiestCapacity = currentCapacity;
                        indexEmptiestBin = binIndex;
                    }
                    ++binIndex;
                }
                ++taskIndex;
            }
        }
        return toReturn;
    }
}

