/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.constraint.ConstraintList;
import org.polarsys.chess.core.constraint.IConstraint;
import org.polarsys.chess.core.preferences.FilterableConstraint;

public class ConstraintPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static int i = 0;

    public ConstraintPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("List of dynamic constraints.");
        System.out.println("ConstraintPreferencePage" + ++i);
    }

    public void createFieldEditors() {
        ArrayList<FilterableConstraint> list = ConstraintList.getList();
        if (!list.isEmpty()) {
            for (FilterableConstraint c : ConstraintList.getList()) {
                IConstraint cc = c.getConstraint();
                BooleanFieldEditor b = new BooleanFieldEditor(cc.getName(), cc.getMessage(), 1, this.getFieldEditorParent());
                this.addField((FieldEditor)b);
            }
        }
        this.addField("DiagramInView", "Diagrams must be created inside the proper CHESS views");
        this.addField("PaletteInView", "Hide Diagram Palettes according to the current CHESS views");
        this.addField("StateMachine", "State machines must be created inside leaf components");
        this.addField("SupportedDiagram", "Allow the creation of supported-only diagrams");
        this.addField("PortDirections", "Flow ports on ends of connection must have compatible directions");
        this.addField("PortTypes", "Flow ports on the ends of connection must have compatible types");
        this.addField("PropertyType", "Properties must have valid types");
        this.addField("OpaqueBehavior", "Opaque Behaviors must be defined using the proper language");
        this.addField("OpaqueExpression", "Opaque Expressions must be defined using the proper language");
    }

    private void addField(String name, String text) {
        BooleanFieldEditor b4 = new BooleanFieldEditor(name, text, 1, this.getFieldEditorParent());
        this.addField((FieldEditor)b4);
    }

    public boolean performOk() {
        super.performOk();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (FilterableConstraint c : ConstraintList.getList()) {
            IConstraint cc = c.getConstraint();
            c.setActive(store.getBoolean(cc.getName()));
        }
        return true;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("CHESS Core Constraints");
    }

    public IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

