/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.handlers;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.m2m.transformations.TransUtil;
import org.polarsys.chess.m2m.ui.AnalysisContextSelectionDialog;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class PurgePSMHandler
extends AbstractHandler {
    @Inject
    Shell activeShell;
    protected IEditorPart editor;

    public Status execute(ExecutionEvent event) throws ExecutionException {
        this.editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Class contextClass = null;
        if (!CHESSEditorUtils.isCHESSProject((IEditorPart)this.editor)) {
            return null;
        }
        Resource inResource = null;
        try {
            inResource = ResourceUtils.getUMLResource((ServicesRegistry)((PapyrusMultiDiagramEditor)this.editor).getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.activeShell, (String)"CHESS", (String)"Unable to load the model");
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.activeShell = window.getShell();
        IFile modelFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        ModelContent inModel = TransUtil.loadModel(modelFile);
        Model cfr_ignored_0 = (Model)inModel.getContent().get(0);
        ArrayList<Class> selection = new ArrayList<Class>();
        final Model model = (Model)inResource.getContents().get(0);
        EList elemList = model.allOwnedElements();
        for (Element elem : elemList) {
            if (!(elem instanceof Class) || elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null || ViewUtils.isPSMView((Package)ViewUtils.getView((EObject)elem))) continue;
            selection.add((Class)elem);
        }
        if (selection.size() == 0) {
            this.activeShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)PurgePSMHandler.this.activeShell, (String)"CHESS", (String)"no suitable analysis contexts in the model");
                }
            });
            return null;
        }
        String contextQN = null;
        AnalysisContextSelectionDialog dialog = new AnalysisContextSelectionDialog(this.activeShell, selection, "Select Analysis Context to purge");
        if (dialog.open() == 0) {
            contextQN = dialog.getContext();
        }
        for (Element elem : model.allOwnedElements()) {
            if (elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null || !((NamedElement)elem).getQualifiedName().equals(contextQN)) continue;
            contextClass = (Class)elem;
        }
        if (contextClass == null) {
            return null;
        }
        final String saAnalysisName = contextClass.getQualifiedName();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(contextClass);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                try {
                    PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                    DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor);
                    ds.setUserAction(false);
                    TransUtil.purgeModel(model, saAnalysisName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageDialog.openError(null, (String)"CHESS", (String)("Problems while executing purge command: " + e.getMessage()));
                }
            }
        });
        return null;
    }
}

