/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.gui.utils;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ReportProblemsUtil {
    public static void cleanResource(IResource resource) throws CoreException {
        resource.deleteMarkers(null, true, 2);
    }

    public static IMarker reportWarning(IResource resource, String ownerField, String ownerName, String msg, int lineNumber, int charStart, int charEnd) throws CoreException, NullPointerException {
        return ReportProblemsUtil.reportMessage(resource, ownerField, ownerName, msg, lineNumber, charStart, charEnd, "org.eclipse.core.resources.problemmarker", 1);
    }

    public static IMarker reportError(IResource resource, String ownerField, String ownerName, String msg, int lineNumber, int charStart, int charEnd) throws CoreException, NullPointerException {
        return ReportProblemsUtil.reportMessage(resource, ownerField, ownerName, msg, lineNumber, charStart, charEnd, "org.eclipse.core.resources.problemmarker", 2);
    }

    public static IMarker reportInfo(IResource resource, String ownerField, String ownerName, String msg, int lineNumber, int charStart, int charEnd) throws CoreException, NullPointerException {
        return ReportProblemsUtil.reportMessage(resource, ownerField, ownerName, msg, lineNumber, charStart, charEnd, "org.eclipse.core.resources.problemmarker", 0);
    }

    private static IMarker reportMessage(IResource resource, String ownerField, String ownerName, String msg, int lineNumber, int charStart, int charEnd, String type, int severity) throws CoreException, NullPointerException {
        if (resource == null) {
            throw new NullPointerException("Resource is null");
        }
        IMarker m = resource.createMarker(type);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("priority", new Integer(2));
        attributes.put("severity", new Integer(severity));
        if (lineNumber > 0) {
            attributes.put("lineNumber", new Integer(lineNumber));
        }
        attributes.put("message", msg);
        if (charStart > 0) {
            attributes.put("charStart", new Integer(charStart));
        }
        if (charEnd > 0) {
            attributes.put("charEnd", new Integer(charEnd));
        }
        attributes.put(ownerField, ownerName);
        m.setAttributes(attributes);
        return m;
    }
}

