/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.service;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.impl.EObjectTreeElementImpl;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.properties.PropertySheet;
import org.polarsys.chess.core.resourcelistener.SelectionListenerExtra;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.core.exceptions.NoDiagramStatusException;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.internal.Activator;
import org.polarsys.chess.service.internal.commands.switchers.SwitchSourceProvider;
import org.polarsys.chess.service.internal.palette.PaletteManager;

public class SelectionListener
extends SelectionListenerExtra {
    DiagramStatus diagramStatus = null;

    private void retrieveDiagramStatus() throws NoDiagramStatusException {
        if (this.diagramStatus == null) {
            this.diagramStatus = CHESSEditorUtils.getDiagramStatus(this.getRegistry());
        }
        if (this.diagramStatus == null) {
            throw new NoDiagramStatusException();
        }
    }

    private void processPart(IWorkbenchPart part, ISelection selection) {
        TreeSelection tSelection;
        Object fElement;
        if (part instanceof PropertySheet) {
            part = ((PropertySheet)part).getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        } else if (part instanceof PapyrusMultiDiagramEditor && CHESSEditorUtils.isCHESSProject((IEditorPart)part)) {
            PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)part;
            IPage activePage = editor.getISashWindowsContainer().getActiveSashWindowsPage();
            this.diagramStatus.setActualView(activePage);
            PaletteManager.setPaletteVisibility(editor, this.diagramStatus);
        } else if (part instanceof ModelExplorerPageBookView && selection instanceof TreeSelection && !selection.isEmpty() && (fElement = (tSelection = (TreeSelection)selection).getFirstElement()) instanceof EObjectTreeElementImpl) {
            this.diagramStatus.setActualView(tSelection);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        try {
            this.retrieveDiagramStatus();
            this.diagramStatus.setUserAction(true);
            this.processPart(part, selection);
            IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
            if (window.getActivePage() != null) {
                this.updateStatus(window);
            }
        }
        catch (NoDiagramStatusException e1) {
            Activator.error(null, e1);
        }
        catch (Exception e2) {
            Activator.error(null, e2);
        }
    }

    private void updateStatus(IWorkbenchWindow window) {
        ISourceProviderService spService = (ISourceProviderService)window.getService(ISourceProviderService.class);
        SwitchSourceProvider sp = (SwitchSourceProvider)spService.getSourceProvider("org.polarsys.chess.service.commands.switchState");
        sp.updateStatus(window.getActivePage().getActiveEditor());
    }
}

