/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.checkerManager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.checkers.Activator;
import org.polarsys.chess.checkers.core.checkerManager.CheckerManager;
import org.polarsys.chess.checkers.core.checkerManager.CheckerMessage;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public abstract class Checker {
    private static final Logger logger = Logger.getLogger(Checker.class);
    public static String FAMILY = "checkers";
    public final String unifiedName;
    protected final Set<String> checkerTags;
    protected final int registerPriority;
    private ArrayList<Exception> errors = new ArrayList();

    protected Checker(String unifiedName, Set<String> checkerTags) {
        this(unifiedName, checkerTags, 0);
    }

    public Checker(String unifiedName, Set<String> checkerTags, int registerPriority) {
        this.unifiedName = unifiedName;
        this.checkerTags = checkerTags;
        this.registerPriority = registerPriority;
        CheckerManager checkerManager = Activator.getCheckerManager();
        logger.debug((Object)("register " + unifiedName));
        checkerManager.getCheckersContainter().register(this);
    }

    public abstract List<CheckerMessage> check(IProgressMonitor var1) throws Exception;

    public abstract void initSync(Package var1) throws Exception;

    public abstract void init() throws Exception;

    public void asyncCheck(boolean isFirstChecker) throws Exception {
        final CheckerManager checkerManager = Activator.getCheckerManager();
        Package pack = EntityUtil.getInstance().getCurrentSystemView();
        if (pack == null) {
            IFile file = EntityUtil.getInstance().getCurrentIFile();
            logger.debug((Object)("file: " + file));
            EntityUtil.getInstance().openCurrentModelIntoEditor(file);
        }
        final IFile iFile = WorkspaceSynchronizer.getFile((Resource)EntityUtil.getInstance().getCurrentSystemView().eResource());
        this.init();
        logger.debug((Object)("running checker: " + this.unifiedName));
        Job job = new Job("Checker Manager: " + this.unifiedName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Checker.this.errors = new ArrayList();
                    List<CheckerMessage> messages = Checker.this.check(monitor);
                    if (messages != null) {
                        checkerManager.deleteProjectMarkers(iFile.getProject(), Checker.this.unifiedName);
                        checkerManager.addMessages(Checker.this.unifiedName, messages);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("Checker '" + Checker.this.unifiedName + "' exception: " + e.getMessage()));
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    logger.warn((Object)("checker '" + Checker.this.unifiedName + "' isCanceled"));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(isFirstChecker);
        job.schedule();
    }

    public Job syncCheck(Package pack) {
        final CheckerManager checkerManager = Activator.getCheckerManager();
        final IFile iFile = WorkspaceSynchronizer.getFile((Resource)pack.eResource());
        logger.debug((Object)("running checker: " + this.unifiedName));
        Job job = new Job("Checker Manager: " + this.unifiedName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Checker.this.errors = new ArrayList();
                    List<CheckerMessage> messages = Checker.this.check(monitor);
                    checkerManager.updateCheckerStatus(Checker.this.unifiedName, true);
                    if (messages != null) {
                        checkerManager.deleteProjectMarkers(iFile.getProject(), Checker.this.unifiedName);
                        checkerManager.addMessages(Checker.this.unifiedName, messages);
                    }
                }
                catch (Exception e) {
                    checkerManager.updateCheckerStatus(Checker.this.unifiedName, true);
                    e.printStackTrace();
                    logger.error((Object)("Checker '" + Checker.this.unifiedName + "' exception: " + e.getMessage()));
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    checkerManager.updateCheckerStatus(Checker.this.unifiedName, true);
                    logger.warn((Object)("checker '" + Checker.this.unifiedName + "' isCanceled"));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return FAMILY.equals(family);
            }
        };
        job.schedule();
        return job;
    }

    public boolean belongsTo(Set<String> checkersTags) {
        for (String tag : checkersTags) {
            if (!this.checkerTags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public String getUnifiedName() {
        return this.unifiedName;
    }

    public Set<String> getCheckerTags() {
        return this.checkerTags;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }
}

