/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.integration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Constraint;
import org.osgi.framework.Bundle;
import org.polarsys.chess.contracts.integration.Activator;
import org.polarsys.chess.contracts.integration.InputStreamer;

public class ToolIntegration {
    private String ocraPath = Activator.getDefault().getPreferenceStore().getString("OCRA_PATH");
    private String xsapScriptPath = Activator.getDefault().getPreferenceStore().getString("XSAP_PATH");
    private File cmdFile;
    private Shell shell;
    private String resultFold;
    private String result;
    private String error;
    private String tempFold;

    public ToolIntegration(Shell activeShell) {
        this.initCmdFile();
        this.shell = activeShell;
    }

    public ToolIntegration(Shell activeShell, String resultFold, String tempFold) {
        this.initCmdFile();
        this.shell = activeShell;
        this.resultFold = resultFold;
        this.tempFold = tempFold;
    }

    private void initCmdFile() {
        Bundle bundle = Platform.getBundle((String)"org.polarsys.chess.contracts.integration");
        URL fileURL = bundle.getEntry("resources/cmd_source");
        try {
            fileURL = FileLocator.toFileURL((URL)fileURL);
            this.cmdFile = URIUtil.toFile((URI)URIUtil.toURI((URL)fileURL));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String FTA(String smvPath, String extensionsPath, String conditionFTA) {
        try {
            String resultName = smvPath.substring(smvPath.lastIndexOf(File.separator) + 1, smvPath.length());
            resultName = resultName.substring(0, resultName.lastIndexOf("."));
            this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_log_ext.txt";
            this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_result_ext.txt";
            File extendScript = new File(String.valueOf(this.xsapScriptPath) + File.separator + "extend_model.py");
            File computeScript = new File(String.valueOf(this.xsapScriptPath) + File.separator + "compute_ft.py");
            File viewScript = new File(String.valueOf(this.xsapScriptPath) + File.separator + "view_ft.py");
            if (extendScript.exists()) {
                String[] extend_cmd = new String[]{"python", extendScript.getPath(), "-v", "-x", "-d", this.tempFold, smvPath, extensionsPath};
                this.callOcraTool(extend_cmd);
                if (computeScript.exists()) {
                    this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_log_ft.txt";
                    this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_result_ft.txt";
                    String[] compute_cmd = new String[]{"python", computeScript.getPath(), "-v", "-d", this.tempFold, "--prop-text", conditionFTA};
                    this.callOcraTool(compute_cmd);
                    if (viewScript.exists()) {
                        this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_log_vt.txt";
                        this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_result_vt.txt";
                        String[] view_cmd = new String[]{"python", viewScript.getPath(), "-v", "-d", this.tempFold};
                        this.callOcraTool(view_cmd);
                    } else {
                        this.displayErrorMessage("view_ft.py not found");
                    }
                } else {
                    this.displayErrorMessage("compute_ft.py not found");
                }
            } else {
                this.displayErrorMessage("extend_model.py not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayErrorMessage(e.getMessage());
        }
        return this.result;
    }

    public String checkRefinement(String modelPath) {
        try {
            String resultName = modelPath.substring(modelPath.lastIndexOf(File.separator) + 1, modelPath.length());
            resultName = resultName.substring(0, resultName.lastIndexOf("."));
            this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_error.txt";
            this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_result.txt";
            PrintWriter writer = new PrintWriter(this.cmdFile);
            writer.println("set on_failure_script_quits");
            writer.println("ocra_check_refinement -i  \"" + modelPath + "\"");
            writer.println("quit");
            writer.flush();
            writer.close();
            String[] cmd = new String[]{this.ocraPath, "-source", this.cmdFile.getPath()};
            this.callOcraTool(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayErrorMessage(e.getMessage());
        }
        return this.result;
    }

    public String checkValidationProp(String modelPath) {
        try {
            String resultName = modelPath.substring(modelPath.lastIndexOf(File.separator) + 1, modelPath.length());
            resultName = resultName.substring(0, resultName.lastIndexOf("."));
            this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_error.txt";
            this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_consistency_result.txt";
            PrintWriter writer = new PrintWriter(this.cmdFile);
            writer.println("set on_failure_script_quits 1");
            writer.println("set ocra_discrete_time");
            writer.println("ocra_check_syntax -i \"" + modelPath + "\"");
            writer.println("ocra_check_validation_prop -i  \"" + modelPath + "\"" + " -a ic3 -s");
            writer.println("quit");
            writer.flush();
            writer.close();
            String[] cmd = new String[]{this.ocraPath, "-source", this.cmdFile.getPath()};
            this.callOcraTool(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayErrorMessage(e.getMessage());
        }
        return this.result;
    }

    public void checkImplementation(String modelPath, String smvPath, String name) {
        String resultName = smvPath.substring(smvPath.lastIndexOf(File.separator) + 1, smvPath.length());
        resultName = resultName.substring(0, resultName.lastIndexOf("."));
        this.error = String.valueOf(this.resultFold) + File.separator + resultName + "_error.txt";
        this.result = String.valueOf(this.resultFold) + File.separator + resultName + "_result.txt";
        try {
            PrintWriter writer = new PrintWriter(this.cmdFile);
            writer.println("set on_failure_script_quits");
            writer.println("ocra_check_implementation -i  \"" + modelPath + "\"" + " -I " + "\"" + smvPath + "\"" + " -c " + name);
            writer.println("quit");
            writer.flush();
            writer.close();
            String[] cmd = new String[]{this.ocraPath, "-source", this.cmdFile.getPath()};
            this.callOcraTool(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayErrorMessage(e.getMessage());
        }
    }

    public boolean checkFormalProperty(Constraint formalProp) {
        String spec;
        PrintWriter writer;
        block4: {
            try {
                writer = new PrintWriter(this.cmdFile);
                writer.println("set on_failure_script_quits");
                spec = formalProp.getSpecification().stringValue();
                if (spec != null) break block4;
                writer.close();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.shell != null) {
                    MessageDialog.openError((Shell)this.shell, (String)"Problem during analysis", (String)e.getMessage());
                }
                return false;
            }
        }
        spec = spec.replace("\n", "").replace("\r", "").replace(";", "");
        writer.println("ocra_check_syntax -c -p \"" + spec + "\"");
        writer.println("quit");
        writer.flush();
        writer.close();
        String[] cmd = new String[]{this.ocraPath, "-source", this.cmdFile.getPath()};
        int exitVal = this.callOcraTool(cmd);
        return exitVal == 0;
    }

    private int callOcraTool(String[] cmd) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        InputStreamer errorStreamer = this.error != null ? new InputStreamer(proc.getErrorStream(), "ERROR", this.error) : new InputStreamer(proc.getErrorStream(), "ERROR");
        InputStreamer outputStreamer = this.result != null ? new InputStreamer(proc.getInputStream(), "OUTPUT", this.result) : new InputStreamer(proc.getInputStream(), "OUTPUT");
        errorStreamer.start();
        outputStreamer.start();
        return proc.waitFor();
    }

    private void displayErrorMessage(final String message) {
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)ToolIntegration.this.shell, (String)"Problems found during analysis", (String)message);
            }
        });
    }
}

