/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.verificationService.ui.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services.SmvExportServiceUI;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.services.NuXmvExecService;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.utils.NuXmvDirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.model.UMLStateMachineModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.core.utils.FileNamesUtil;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ModelCheckingCommand
extends AbstractJobCommand {
    private static final Logger logger = Logger.getLogger(ModelCheckingCommand.class);
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private SmvExportServiceUI smvExportService = SmvExportServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance(), (AbstractStateMachineModel)UMLStateMachineModel.getInstance());
    private NuXmvExecService nuXmvExecService = NuXmvExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private static NuXmvDirectoryUtil nuXmvDirectoryUtil = NuXmvDirectoryUtil.getInstance();
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private EntityUtil entityUtil = EntityUtil.getInstance();
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private boolean isProgrExec;
    private Class umlSelectedComponent;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private boolean showPopups;
    private boolean usexTextValidation;
    private String smvFileDirectory;
    private int timeSpecification = 1;
    private boolean isDiscreteTime;
    private boolean isAsyncCommunication;
    private String monolithicSMVFilePath;
    private String resultFilePath;
    private String smvMapDirPath;
    private Resource umlSelectedResource;
    private String ossDirPath;
    private boolean commandExecuted;
    private EList<String> conditions;
    private List<AnalysisContextElement> contextList;
    String generatedSmvFilePath;
    boolean internalExecution = true;
    boolean isLeafComponent;

    public ModelCheckingCommand() {
        super("Model Checking");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        this.isProgrExec = this.isProgrExec(event);
        if (!this.isProgrExec) {
            logger.debug((Object)"!isProgrammaticallyExecution(event)");
            try {
                this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
            }
            catch (NoComponentException noComponentException) {
                this.umlSelectedComponent = this.analysisResultUtil.getSystemComponentFromEvent(event);
            }
            this.isLeafComponent = this.isLeafComponent(this.umlSelectedComponent);
            if (!this.isLeafComponent) {
                this.isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
            }
            this.timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
            this.smvFileDirectory = nuXmvDirectoryUtil.getSmvFileDirectory();
            this.monolithicSMVFilePath = nuXmvDirectoryUtil.getMonolithicSMVFilePath(this.umlSelectedComponent.getName());
            this.smvMapDirPath = nuXmvDirectoryUtil.getSmvFileDirectory();
            this.ossDirPath = this.ocraDirectoryUtil.getOSSDirPath();
            this.umlSelectedResource = this.umlSelectedComponent.eResource();
            this.showPopups = false;
            this.usexTextValidation = true;
            this.resultFilePath = FileNamesUtil.getInstance().computeModelCheckingFileName(this.umlSelectedComponent);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
            if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
                SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
                dialog.open();
                if (dialog.goAhead()) {
                    this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
                }
            }
            PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
            Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
            Model model = ResourceUtils.getModel((Resource)res);
            this.contextList = AnalysisResultUtil.getInstance().getAnalysisContexts(this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, Analysis.MODEL_CHECKING_ANALYSIS, model);
        } else {
            this.setParamsForProgrExec(event);
        }
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        if (!this.isProgrExec) {
            if (this.isLeafComponent) {
                this.generatedSmvFilePath = this.smvExportService.exportSingleSmv((Object)this.umlSelectedComponent, this.showPopups, this.smvFileDirectory, monitor, this.timeSpecification);
            } else {
                logger.debug((Object)"exportSmv");
                HashMap smvPathComponentNameMap = this.smvExportService.exportSmv((Object)this.umlSelectedComponent, this.showPopups, this.smvFileDirectory, monitor, this.timeSpecification);
                logger.debug((Object)"createMonolithicSMV");
                this.ocraExecService.createMonolithicSMV((Object)this.umlSelectedComponent, this.umlSelectedResource, smvPathComponentNameMap, this.timeSpecification, this.isAsyncCommunication, this.usexTextValidation, this.showPopups, this.ossDirPath, this.smvMapDirPath, this.monolithicSMVFilePath, this.internalExecution, monitor);
                this.generatedSmvFilePath = this.monolithicSMVFilePath;
                logger.debug((Object)"createMonolithicSMV done");
            }
        }
    }

    private EList<String> createConditions(String[] expression) {
        BasicEList conditions = new BasicEList();
        if (expression != null) {
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"check_type", (String)expression[0]);
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"property", (String)expression[1]);
        }
        return conditions;
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        String[] expression = new String[1];
        this.commandExecuted = this.nuXmvExecService.executeModelChecking(this.timeSpecification, this.generatedSmvFilePath, this.resultFilePath, event.getParameter("algorithm_type"), event.getParameter("check_type"), event.getParameter("property"), this.isProgrExec, this.internalExecution, expression, this.contextList, this.umlSelectedComponent.getName());
        this.conditions = this.createConditions(expression[0].split("#"));
        if (this.commandExecuted) {
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.MODEL_CHECKING_ANALYSIS, this.conditions, this.resultFilePath, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, null);
            this.analysisResultUtil.showResult("nuxmv_check_model", this.resultFilePath);
        }
    }

    private boolean isLeafComponent(Class umlSelectedComponent) {
        EList subComponents = ChessSystemModel.getInstance().getSubComponentsInstances((Object)umlSelectedComponent);
        return subComponents == null || subComponents.size() == 0;
    }

    public boolean isProgrExec(ExecutionEvent event) {
        String paramisProgrExec = event.getParameter("isProgrExec");
        if (paramisProgrExec != null) {
            return Boolean.valueOf(paramisProgrExec);
        }
        return false;
    }

    private void setParamsForProgrExec(ExecutionEvent event) throws Exception {
        String elementURI = event.getParameter("elementURI");
        String projectName = event.getParameter("projectName");
        String modelName = event.getParameter("modelName");
        String projectPath = event.getParameter("projectPath");
        this.resultFilePath = event.getParameter("resultFilePath");
        logger.debug((Object)elementURI);
        logger.debug((Object)projectName);
        logger.debug((Object)modelName);
        logger.debug((Object)projectPath);
        logger.debug((Object)"isProgrammaticallyExecution(event)");
        this.umlSelectedComponent = (Class)this.entityUtil.getElement(projectName, modelName, elementURI);
        String paramIsDiscrete = event.getParameter("isDiscrete");
        this.isDiscreteTime = Boolean.valueOf(paramIsDiscrete);
        this.smvFileDirectory = nuXmvDirectoryUtil.getSmvFileDirectory(projectPath);
        this.monolithicSMVFilePath = nuXmvDirectoryUtil.getMonolithicSMVFilePath(projectPath, this.umlSelectedComponent.getName());
        this.smvMapDirPath = nuXmvDirectoryUtil.getSmvFileDirectory(projectPath);
        this.ossDirPath = this.ocraDirectoryUtil.getOSSDirPath(projectPath);
    }
}

