/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.resourcelistener;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.resourcelistener.ResourceSetListenerExtra;

public class ResourceSetListenerManager
extends ResourceSetListenerExtra {
    private Hashtable<String, ResourceSetListenerExtra> listenerRegistry = new Hashtable();
    private String MODELLISTENERID_EXTENSION_ID = "org.polarsys.chess.resourceListener";
    private String NAME_ID = "name";
    private String REALIZATION_ID = "realization";

    public ResourceSetListenerManager(ServicesRegistry serviceRegistry) {
        this.sr = serviceRegistry;
        this.initializeListenerList();
    }

    private void initializeListenerList() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.MODELLISTENERID_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.inializeOneRule(configElements[i]);
            ++i;
        }
    }

    private void inializeOneRule(IConfigurationElement element) {
        String listenerName = element.getAttribute(this.NAME_ID);
        try {
            ResourceSetListenerExtra listener = (ResourceSetListenerExtra)((Object)ResourceSetListenerManager.createExtension(element, element.getAttribute(this.REALIZATION_ID)));
            listener.setRegistry(this.sr);
            this.listenerRegistry.put(listenerName, listener);
        }
        catch (Exception e) {
            System.err.println("- " + listenerName + " can not be loaded: " + e);
            e.printStackTrace();
        }
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }

    public String toString() {
        String out = "ModelListener: \n";
        Enumeration<String> keyenum = this.listenerRegistry.keys();
        while (keyenum.hasMoreElements()) {
            String aKey = keyenum.nextElement();
            out = String.valueOf(out) + "- " + aKey.toString() + " (" + ((Object)((Object)this.listenerRegistry.get(aKey))).toString() + ")\n";
        }
        return out;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        Enumeration<String> registrykeys = this.listenerRegistry.keys();
        Command c = null;
        CompoundCommand command = new CompoundCommand();
        while (registrykeys.hasMoreElements()) {
            String registryKey = registrykeys.nextElement();
            c = this.listenerRegistry.get(registryKey).transactionAboutToCommit(event);
            if (c == null) continue;
            command.append(c);
            break;
        }
        return command.isEmpty() ? super.transactionAboutToCommit(event) : command;
    }
}

