/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.util.uml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.edit.part.BlockDefinitionDiagramEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomPackageEditPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DiagramUtils {
    private static final String STMD = "PapyrusUMLStateMachineDiagram";
    private static final String BDD = "BlockDefinition";
    private static final String IBD = "InternalBlock";

    public static boolean isBlockDefinitionDiagram(Diagram diagram) {
        return diagram.getType().equals(BDD);
    }

    public static boolean isInternalBlockDiagram(Diagram diagram) {
        return diagram.getType().compareTo(IBD) == 0;
    }

    public static boolean isStateMachineDiagram(Diagram diagram) {
        return diagram.getType().compareTo(STMD) == 0;
    }

    public static Diagram getBDD(Collection<Diagram> diagrams, EObject element) {
        for (Diagram diagram : diagrams) {
            if (!DiagramUtils.isBlockDefinitionDiagram(diagram) || diagram.getElement() != element) continue;
            return diagram;
        }
        return null;
    }

    public static Diagram getSMD(Collection<Diagram> diagrams, EObject element) {
        for (Diagram diagram : diagrams) {
            if (!DiagramUtils.isStateMachineDiagram(diagram) || diagram.getElement() != element) continue;
            return diagram;
        }
        return null;
    }

    public static Collection<Diagram> getDiagrams() {
        NotationModel notationModel = NotationUtils.getNotationModel();
        Set<Diagram> diagrams = DiagramUtils.getChessDiagrams(notationModel.getResources());
        return diagrams;
    }

    public static Set<Diagram> getDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                if (!(element instanceof Diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    public static Set<Diagram> getChessDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                Diagram diagram;
                if (!(element instanceof Diagram) || !DiagramUtils.isBlockDefinitionDiagram(diagram = (Diagram)element) && !DiagramUtils.isInternalBlockDiagram(diagram) && !DiagramUtils.isStateMachineDiagram(diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    public static boolean isBlockDefinitionDiagram(ExecutionEvent event) {
        GraphicalEditPart selectedEditPart = DiagramUtils.getSelectedGraphicalObject(event);
        return selectedEditPart instanceof BlockDefinitionDiagramEditPart;
    }

    public static Diagram getDiagramFromSelection(ExecutionEvent event) {
        GraphicalEditPart selectedEditPart = DiagramUtils.getSelectedGraphicalObject(event);
        EditPart parentEditPart = selectedEditPart.getParent();
        while (!(parentEditPart instanceof CustomPackageEditPart)) {
            parentEditPart = parentEditPart.getParent();
        }
        return ((CustomPackageEditPart)parentEditPart).getDiagramView();
    }

    private static GraphicalEditPart getSelectedGraphicalObject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        return (GraphicalEditPart)((IStructuredSelection)selection).getFirstElement();
    }
}

