/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm.analysis;

import java.util.LinkedList;
import java.util.List;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.analysis.FlaLogger;

public class FlaSystem {
    Component rootComponent;
    boolean propagateUnmatchedFailures = true;
    boolean treatUnmentionedPortsAsWildcards = true;
    boolean initToNoFailure = true;
    private static List<Component> updatedComponents = new LinkedList<Component>();
    private static boolean staticPropagateUnmatchedFailures;
    private static boolean staticTreatUnmentionedPortsAsWildcards;
    private static boolean staticInitToNoFailure;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    protected void setRootComponent(Component rootComponent) {
        this.rootComponent = rootComponent;
    }

    public FlaSystem() {
    }

    public FlaSystem(Component rootComponent) {
        this.rootComponent = rootComponent;
    }

    public void initializeNoFailure(boolean initToNoFailure) {
        this.initToNoFailure = initToNoFailure;
    }

    public void propagateUnmatchedFailures(boolean propagateUnmatchedFailures) {
        this.propagateUnmatchedFailures = propagateUnmatchedFailures;
    }

    public void treatUnmentionedPortsAsWildcards(boolean treatUnmentionedPortsAsWildcards) {
        this.treatUnmentionedPortsAsWildcards = treatUnmentionedPortsAsWildcards;
    }

    public void performAnalysis(FlaLogger logger) {
        staticPropagateUnmatchedFailures = this.propagateUnmatchedFailures;
        staticTreatUnmentionedPortsAsWildcards = this.treatUnmentionedPortsAsWildcards;
        staticInitToNoFailure = this.initToNoFailure;
        this.rootComponent.initialize(this.initToNoFailure);
        FlaSystem.addUpdatedComponent(this.rootComponent);
        while (!updatedComponents.isEmpty()) {
            Component updatedComponent = updatedComponents.remove(0);
            updatedComponent.propagateFailures();
        }
    }

    public static boolean initializeNoFailure() {
        return staticInitToNoFailure;
    }

    public static boolean propagateUnmatchedFailures() {
        return staticPropagateUnmatchedFailures;
    }

    public static boolean treatUnmentionedPortsAsWildcards() {
        return staticTreatUnmentionedPortsAsWildcards;
    }

    public static void addUpdatedComponent(Component updatedComponent) {
        if (!updatedComponents.contains(updatedComponent)) {
            updatedComponents.add(updatedComponent);
        }
    }
}

