/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.internal.commands.switchers.SwitchSourceProvider;
import org.polarsys.chess.service.internal.service.CHESSService;

public class CurrentViewStatusCommand
extends AbstractHandler
implements IElementUpdater {
    public static String COMMAND_ID = "org.polarsys.chess.service.CurrentViewStatus";

    public CurrentViewStatusCommand() {
        SwitchSourceProvider.commandsToRefresh.add(COMMAND_ID);
    }

    public static void refresh() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        service.refreshElements(COMMAND_ID, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DiagramStatus diagramStatus;
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor != null && (diagramStatus = CHESSEditorUtils.getDiagramStatus(editor)) != null && diagramStatus != null && diagramStatus.getCurrentView() != null) {
            String n = diagramStatus.getActiveView();
            element.setTooltip(n);
            element.setIcon(CHESSService.viewIcons.get(n));
            return;
        }
        element.setIcon(CHESSService.viewIcons.get("NullView"));
        element.setTooltip("NullView");
        element.setText(" ");
    }
}

