/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.validator.messages.Messages;

public class DiagramChecker {
    Set<String> supportedDiagrams = new HashSet<String>(Arrays.asList("BlockDefinition", "RequirementDiagram", "InternalBlock", "PapyrusUMLStateMachineDiagram"));
    public static String classDiagramKind = "PapyrusUMLClassDiagram";
    private static DiagramChecker instance = new DiagramChecker();

    public static DiagramChecker loadDiagramChecker() {
        return instance;
    }

    public void check(Diagram diagram, StringBuffer s, DiagramStatus.DesignView currentView, TransactionalEditingDomain domain) throws RollbackException {
        Boolean checkDiagramType = Activator.getDefault().getPreferenceStore().getBoolean("SupportedDiagram");
        if (checkDiagramType.booleanValue() && !this.hasSupportedType(diagram)) {
            s.append(Messages.error_diagramSupportType);
            throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", Messages.error_diagramSupportType));
        }
        Boolean checkDiagramInView = Activator.getDefault().getPreferenceStore().getBoolean("DiagramInView");
        System.out.println("diagram: " + diagram);
        if (checkDiagramInView.booleanValue()) {
            if (diagram.getElement() instanceof Model) {
                throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", Messages.error_diagramInView));
            }
            if (!currentView.isDiagramAllowed(diagram)) {
                throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", Messages.error_diagramCurrentView));
            }
        }
    }

    private boolean hasSupportedType(Diagram diagram) {
        String diagramType = diagram.getType();
        System.out.println("diagramType: " + diagramType);
        return this.supportedDiagrams.contains(diagramType);
    }
}

