/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.wizards.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.category.NewPapyrusModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.utils.SettingsHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.polarsys.chess.core.util.commands.InitCHESSModelCommand;
import org.polarsys.chess.wizards.Activator;
import org.polarsys.chess.wizards.providers.WorkspaceNewModelStorageProvider;

public class CreateCHESSModelWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.uml.diagram.wizards.createmodel";
    public static final String NEW_MODEL_SETTINGS = "NewModelWizard";
    private IWorkbench workbench;
    private WorkspaceNewModelStorageProvider selectedStorageProvider;
    private Map<WorkspaceNewModelStorageProvider, List<IWizardPage>> providerPages = new HashMap<WorkspaceNewModelStorageProvider, List<IWizardPage>>();
    private Map<IWizardPage, WorkspaceNewModelStorageProvider> providersByPage = new HashMap<IWizardPage, WorkspaceNewModelStorageProvider>();
    private int startProviderPageIndex;
    private int endProviderPageIndex;

    public CreateCHESSModelWizard() {
        this.setWindowTitle("New CHESS Model");
    }

    public void addPages() {
        this.startProviderPageIndex = this.getPageCount() - 1;
        ArrayList<IWizardPage> pageList = new ArrayList<IWizardPage>(3);
        for (IWizardPage iWizardPage : this.selectedStorageProvider.createPages()) {
            if (iWizardPage == null) continue;
            pageList.add(iWizardPage);
            this.providersByPage.put(iWizardPage, this.selectedStorageProvider);
            this.addPage(iWizardPage);
        }
        this.providerPages.put(this.selectedStorageProvider, pageList);
        this.endProviderPageIndex = this.getPageCount();
    }

    protected final void addPageIfNotNull(IWizardPage page) {
        if (page != null) {
            this.addPage(page);
        }
    }

    public boolean isInitModelWizard() {
        return false;
    }

    public boolean isCreateProjectWizard() {
        return false;
    }

    public boolean isCreateMultipleModelsWizard() {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.initStorageProvider(workbench, selection);
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(NEW_MODEL_SETTINGS);
        if (section == null) {
            section = workbenchSettings.addNewSection(NEW_MODEL_SETTINGS);
        }
        this.setDialogSettings(section);
        this.selectedStorageProvider.init(this, selection);
    }

    public boolean performFinish() {
        String[] diagramCategoryIds = this.getDiagramCategoryIds();
        if (diagramCategoryIds.length == 0) {
            return false;
        }
        String diagramCategoryId = diagramCategoryIds[0];
        URI newURI = this.createNewModelURI(diagramCategoryId);
        this.createAndOpenCHESSModel(newURI, diagramCategoryId);
        return true;
    }

    protected URI createNewModelURI(String diagramCategoryID) {
        return this.selectedStorageProvider.createNewModelURI(diagramCategoryID);
    }

    protected boolean createAndOpenCHESSModel(URI newURI, String diagramCategoryId) {
        if (newURI == null) {
            return false;
        }
        ServicesRegistry registry = this.createServicesRegistry();
        if (registry == null) {
            return false;
        }
        try {
            try {
                ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
                this.createPapyrusModels(modelSet, newURI);
                this.initServicesRegistry(registry);
                this.initDomainModel(modelSet, newURI, diagramCategoryId);
                this.initDiagramModel(modelSet, diagramCategoryId);
                this.openDiagram(newURI);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                try {
                    registry.disposeRegistry();
                }
                catch (ServiceException serviceException) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                registry.disposeRegistry();
            }
            catch (ServiceException serviceException) {}
            throw throwable;
        }
        try {
            registry.disposeRegistry();
        }
        catch (ServiceException serviceException) {}
        return true;
    }

    protected ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry result = null;
        try {
            result = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        try {
            result.startServicesByClassKeys(new Class[]{ModelSet.class});
        }
        catch (ServiceException serviceException) {}
        return result;
    }

    protected void initServicesRegistry(ServicesRegistry registry) throws ServiceException {
        try {
            registry.startRegistry();
        }
        catch (ServiceException serviceException) {}
        registry.getService(IPageManager.class);
    }

    protected String[] getDiagramCategoryIds() {
        return new String[]{"uml"};
    }

    public String getDiagramFileExtension(String diagramCategoryId) {
        return this.getDiagramFileExtension(diagramCategoryId, "di");
    }

    public String getDiagramFileExtension(String categoryId, String defaultExtension) {
        DiagramCategoryDescriptor diagramCategory = this.getDiagramCategoryMap().get(categoryId);
        String extensionPrefix = diagramCategory != null ? diagramCategory.getExtensionPrefix() : null;
        return extensionPrefix != null ? String.valueOf(extensionPrefix) + "." + defaultExtension : defaultExtension;
    }

    protected void initDomainModel(ModelSet modelSet, URI newURI, String diagramCategoryId) {
        boolean isToInitFromTemplate = false;
        if (isToInitFromTemplate) {
            this.initDomainModelFromTemplate(modelSet);
        } else {
            this.createEmptyDomainModel(modelSet, diagramCategoryId);
            this.getCommandStack(modelSet).execute(null);
            this.getCommandStack(modelSet).execute((Command)new InitCHESSModelCommand(modelSet.getTransactionalEditingDomain(), modelSet));
        }
    }

    protected void initDomainModelFromTemplate(ModelSet modelSet) {
    }

    protected void createEmptyDomainModel(ModelSet modelSet, String diagramCategoryId) {
        try {
            IModelCreationCommand creationCommand = this.getDiagramCategoryMap().get(diagramCategoryId).getCommand();
            creationCommand.createModel(modelSet);
        }
        catch (BackboneException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void createPapyrusModels(ModelSet modelSet, URI newURI) {
        NewPapyrusModelCommand command = new NewPapyrusModelCommand(modelSet, newURI);
        this.getCommandStack(modelSet).execute((Command)command);
    }

    protected void saveDiagramCategorySettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            SettingsHelper settingsHelper = new SettingsHelper(settings);
            settingsHelper.saveDefaultDiagramCategory(this.getDiagramCategoryIds());
        }
    }

    protected void openDiagram(URI newURI) {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                IEditorInput editorInput = this.createEditorInput(newURI);
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.eclipse.papyrus.infra.core.papyrusEditor", (boolean)true);
            }
            catch (PartInitException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected IEditorInput createEditorInput(URI uri) {
        return this.selectedStorageProvider.createEditorInput(uri);
    }

    protected void initDiagramModel(ModelSet modelSet, String categoryId) {
        this.initDiagrams(modelSet, categoryId);
        this.saveDiagram(modelSet);
    }

    private void saveDiagram(ModelSet modelSet) {
        try {
            modelSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void initDiagrams(ModelSet modelSet, String categoryId) {
        this.initDiagrams(modelSet, null, categoryId);
    }

    protected void initDiagrams(ModelSet resourceSet, EObject root, String categoryId) {
        List creationCommands = Collections.emptyList();
        String diagramName = "diagram";
        if (creationCommands.isEmpty()) {
            this.createEmptyDiagramEditor(resourceSet);
        } else {
            int i = 0;
            while (i < creationCommands.size()) {
                ((ICreationCommand)creationCommands.get(i)).createDiagram(resourceSet, root, diagramName);
                ++i;
            }
        }
    }

    private void createEmptyDiagramEditor(ModelSet modelSet) {
        EditorUtils.getIPageMngr((Resource)DiModelUtils.getDiResource((ModelSet)modelSet));
    }

    protected final CommandStack getCommandStack(ModelSet modelSet) {
        return modelSet.getTransactionalEditingDomain().getCommandStack();
    }

    protected Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        return DiagramCategoryRegistry.getInstance().getDiagramCategoryMap();
    }

    public IStatus diagramCategoryChanged(String ... newCategories) {
        return this.selectedStorageProvider.validateDiagramCategories(newCategories);
    }

    protected void initStorageProvider(IWorkbench workbench, IStructuredSelection selection) {
        this.selectedStorageProvider = new WorkspaceNewModelStorageProvider();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        WorkspaceNewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index >= 0 && index < pages.size() - 1) {
                result = pages.get(index + 1);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else if (allPages.indexOf(page) == this.startProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.selectedStorageProvider);
            if (!pages.isEmpty()) {
                result = pages.get(0);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else {
            result = super.getNextPage(page);
        }
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        WorkspaceNewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index > 0) {
                result = pages.get(index - 1);
            } else if (this.startProviderPageIndex >= 0) {
                result = allPages.get(this.startProviderPageIndex);
            }
        } else if (allPages.indexOf(page) == this.endProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.selectedStorageProvider);
            if (!pages.isEmpty()) {
                result = pages.get(pages.size() - 1);
            } else if (this.startProviderPageIndex >= 0) {
                result = allPages.get(this.startProviderPageIndex);
            }
        } else {
            result = super.getPreviousPage(page);
        }
        return result;
    }

    public boolean canFinish() {
        boolean result = true;
        IWizardPage[] allPages = this.getPages();
        int i = 0;
        while (result && i <= this.startProviderPageIndex) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        if (result) {
            for (IWizardPage next : this.providerPages.get(this.selectedStorageProvider)) {
                if (next.isPageComplete()) continue;
                result = false;
                break;
            }
        }
        i = this.endProviderPageIndex;
        while (result && i < allPages.length) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        return result;
    }

    public String getModelKindName() {
        return "Papyrus";
    }
}

