/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.PrimitiveObjectMap;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionImmutableBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutablePrimitiveObjectMap<V>
extends PrimitiveObjectMap<V> {
    @Override
    default public <K, VV> ImmutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf((Object)each);
            Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map.toImmutable();
    }

    @Override
    default public <K, VV> ImmutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        MutableMap map = this.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator, Maps.mutable.empty());
        return map.toImmutable();
    }

    @Override
    default public <K> ImmutableMap<K, V> reduceBy(Function<? super V, ? extends K> groupBy, Function2<? super V, ? super V, ? extends V> reduceFunction) {
        MutableMap map = this.reduceBy(groupBy, reduceFunction, Maps.mutable.empty());
        return map.toImmutable();
    }

    @Override
    public <VV> ImmutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> var1);

    @Override
    public <VV> ImmutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> var1);

    @Override
    default public <VV> ImmutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        MutableMap target = Maps.mutable.withInitialCapacity(this.size());
        return this.groupByUniqueKey(function, target).toImmutable();
    }

    @Override
    public <VV> ImmutableBag<VV> collectIf(Predicate<? super V> var1, Function<? super V, ? extends VV> var2);

    @Override
    public <VV> ImmutableBag<VV> collect(Function<? super V, ? extends VV> var1);

    @Override
    public <VV> ImmutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> var1);

    @Override
    default public <P, VV> ImmutableBag<VV> flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<VV>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public ImmutableBooleanBag collectBoolean(BooleanFunction<? super V> var1);

    @Override
    public ImmutableByteBag collectByte(ByteFunction<? super V> var1);

    @Override
    public ImmutableCharBag collectChar(CharFunction<? super V> var1);

    @Override
    public ImmutableDoubleBag collectDouble(DoubleFunction<? super V> var1);

    @Override
    public ImmutableFloatBag collectFloat(FloatFunction<? super V> var1);

    @Override
    public ImmutableIntBag collectInt(IntFunction<? super V> var1);

    @Override
    public ImmutableLongBag collectLong(LongFunction<? super V> var1);

    @Override
    public ImmutableShortBag collectShort(ShortFunction<? super V> var1);

    @Override
    public <P, VV> ImmutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> var1, P var2);

    @Override
    public <S> ImmutableBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public ImmutableBag<V> select(Predicate<? super V> var1);

    @Override
    public <P> ImmutableBag<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public ImmutableBag<V> reject(Predicate<? super V> var1);

    @Override
    public <P> ImmutableBag<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public PartitionImmutableBag<V> partition(Predicate<? super V> var1);

    @Override
    public <P> PartitionImmutableBag<V> partitionWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    @Deprecated
    public <S> ImmutableBag<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public ImmutableSet<Pair<V, Integer>> zipWithIndex();

    @Override
    public <VV> ImmutableObjectLongMap<VV> sumByInt(Function<? super V, ? extends VV> var1, IntFunction<? super V> var2);

    @Override
    public <VV> ImmutableObjectDoubleMap<VV> sumByFloat(Function<? super V, ? extends VV> var1, FloatFunction<? super V> var2);

    @Override
    public <VV> ImmutableObjectLongMap<VV> sumByLong(Function<? super V, ? extends VV> var1, LongFunction<? super V> var2);

    @Override
    public <VV> ImmutableObjectDoubleMap<VV> sumByDouble(Function<? super V, ? extends VV> var1, DoubleFunction<? super V> var2);
}

