/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.factory.primitive.DoubleBags;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.DoubleSets;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;

public class SelectDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleIterable delegate;
    private final DoublePredicate predicate;

    public SelectDoubleIterable(DoubleIterable delegate, DoublePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public DoubleIterator doubleIterator() {
        return new SelectDoubleIterator(this.delegate, this.predicate);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.forEach((DoubleProcedure)new IfDoubleProcedure(procedure));
    }

    @Override
    public int size() {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty() {
        return !this.doubleIterator().hasNext();
    }

    @Override
    public boolean notEmpty() {
        return this.doubleIterator().hasNext();
    }

    @Override
    public int count(DoublePredicate predicate) {
        CountDoubleProcedure countDoubleProcedure = new CountDoubleProcedure(predicate);
        this.forEach(countDoubleProcedure);
        return countDoubleProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy((DoublePredicate & Serializable)each -> this.predicate.accept(each) && predicate.accept(each));
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.noneSatisfy((DoublePredicate & Serializable)each -> !predicate.accept(each));
    }

    @Override
    public double[] toArray() {
        final double[] array = new double[this.size()];
        this.forEach(new DoubleProcedure(){
            private int index = 0;

            public void value(double each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleLists.mutable.withAll((DoubleIterable)this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleSets.mutable.withAll((DoubleIterable)this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleBags.mutable.withAll((DoubleIterable)this);
    }

    private static final class SelectDoubleIterator
    implements DoubleIterator {
        private final DoubleIterator iterator;
        private final DoublePredicate predicate;
        private double next;
        private boolean verifiedHasNext = false;

        private SelectDoubleIterator(DoubleIterable iterable, DoublePredicate predicate) {
            this(iterable.doubleIterator(), predicate);
        }

        private SelectDoubleIterator(DoubleIterator iterator, DoublePredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                double temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public double next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoubleProcedure procedure;

        private IfDoubleProcedure(DoubleProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(double each) {
            if (SelectDoubleIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate predicate;
        private int counter = 0;

        private CountDoubleProcedure(DoublePredicate predicate) {
            this.predicate = predicate;
        }

        public void value(double each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

