/*
 * Copyright (c) 2017 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableLongList extends ImmutableLongCollection, LongList
{
    @Override
    ImmutableLongList select(LongPredicate predicate);

    @Override
    ImmutableLongList reject(LongPredicate predicate);

    /**
     * @since 9.0.
     */
    @Override
    default ImmutableLongList tap(LongProcedure procedure)
    {
        this.forEach(procedure);
        return this;
    }

    @Override
    <V> ImmutableList<V> collect(LongToObjectFunction<? extends V> function);

    @Override
    ImmutableLongList newWith(long element);

    @Override
    ImmutableLongList newWithout(long element);

    @Override
    ImmutableLongList newWithAll(LongIterable elements);

    @Override
    ImmutableLongList newWithoutAll(LongIterable elements);

    @Override
    ImmutableLongList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableLongList distinct();

    @Override
    ImmutableLongList subList(int fromIndex, int toIndex);
}
