/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.petrinet.PythonPFCConverter;
import org.eclipse.comma.petrinet.PythonSBFCConverter;

public class PythonConstraintConverter {
    static final String indent1 = "    ";
    static final String indent2 = "        ";
    static final String indent3 = "            ";
    static final String indent4 = "                ";
    static final String indent5 = "                    ";
    static final String indent6 = "                        ";

    public static String convert(FunctionalConstraint constraint) {
        if (constraint instanceof StateBasedFunctionalConstraint) {
            return PythonSBFCConverter.convert((StateBasedFunctionalConstraint)constraint);
        }
        if (constraint instanceof PredicateFunctionalConstraint) {
            return PythonPFCConverter.convert((PredicateFunctionalConstraint)constraint);
        }
        throw new RuntimeException("Not supported");
    }

    static String handleUnsupportedExpression(Expression expression) {
        if (expression instanceof ExpressionInterfaceState) {
            ExpressionInterfaceState e = (ExpressionInterfaceState)expression;
            if (e.getPart() != null) {
                throw new RuntimeException("Unsupported");
            }
            return String.format("'%s' in port_machine_state['%s'].values()", e.getState().getName(), e.getPort().getName(), e.getState().getName(), e.getPort().getName());
        }
        throw new RuntimeException("Not supported");
    }
}

