/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class TestKindRegistry {
    public static final String JUNIT3_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit3";
    public static final String JUNIT4_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit4";
    public static final String JUNIT5_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit5";
    private static TestKindRegistry fgRegistry;
    private final IExtensionPoint fPoint;
    private ArrayList<TestKind> fTestKinds;

    public static TestKindRegistry getDefault() {
        if (fgRegistry != null) {
            return fgRegistry;
        }
        fgRegistry = new TestKindRegistry(Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.junit.internal_testKinds"));
        return fgRegistry;
    }

    private TestKindRegistry(IExtensionPoint point) {
        this.fPoint = point;
    }

    public ArrayList<TestKind> getAllKinds() {
        this.loadKinds();
        return this.fTestKinds;
    }

    private void loadKinds() {
        if (this.fTestKinds != null) {
            return;
        }
        ArrayList<TestKind> items = new ArrayList<TestKind>();
        for (IConfigurationElement configurationElement : this.getConfigurationElements()) {
            items.add(new TestKind(configurationElement));
        }
        Collections.sort(items, (kind0, kind1) -> {
            if (kind0.precedes((ITestKind)kind1)) {
                return -1;
            }
            if (kind1.precedes((ITestKind)kind0)) {
                return 1;
            }
            return 0;
        });
        this.fTestKinds = items;
    }

    public ArrayList<String> getDisplayNames() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<TestKind> testTypes = this.getAllKinds();
        for (ITestKind iTestKind : testTypes) {
            result.add(iTestKind.getDisplayName());
        }
        return result;
    }

    public ITestKind getKind(String testKindId) {
        if (testKindId != null) {
            for (TestKind kind : this.getAllKinds()) {
                if (!testKindId.equals(kind.getId())) continue;
                return kind;
            }
        }
        return ITestKind.NULL;
    }

    public static String getContainerTestKindId(IJavaElement element) {
        IJavaProject project;
        if (element != null && CoreTestSearchEngine.is50OrHigher(project = element.getJavaProject())) {
            if (CoreTestSearchEngine.is18OrHigher(project)) {
                if (TestKindRegistry.isRunWithJUnitPlatform(element)) {
                    return JUNIT4_TEST_KIND_ID;
                }
                if (CoreTestSearchEngine.hasJUnit5TestAnnotation(project)) {
                    return JUNIT5_TEST_KIND_ID;
                }
            }
            if (CoreTestSearchEngine.hasJUnit4TestAnnotation(project)) {
                return JUNIT4_TEST_KIND_ID;
            }
        }
        return JUNIT3_TEST_KIND_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunWithJUnitPlatform(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            element = ((ICompilationUnit)element).findPrimaryType();
        }
        if (!(element instanceof IType)) return false;
        IType type = (IType)element;
        try {
            IMemberValuePair[] memberValuePairs;
            IAnnotation runWithAnnotation = type.getAnnotation("RunWith");
            if (!runWithAnnotation.exists()) {
                runWithAnnotation = type.getAnnotation("org.junit.runner.RunWith");
            }
            if (!runWithAnnotation.exists()) return false;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = runWithAnnotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if ("value".equals(memberValuePair.getMemberName()) && "JUnitPlatform".equals(memberValuePair.getValue())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static ITestKind getContainerTestKind(IJavaElement element) {
        return TestKindRegistry.getDefault().getKind(TestKindRegistry.getContainerTestKindId(element));
    }

    private ArrayList<IConfigurationElement> getConfigurationElements() {
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = this.fPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            Collections.addAll(items, extension.getConfigurationElements());
            ++n2;
        }
        return items;
    }

    public String getAllKindIds() {
        ArrayList<TestKind> allKinds = this.getAllKinds();
        StringBuilder returnThis = new StringBuilder();
        for (ITestKind iTestKind : allKinds) {
            returnThis.append("(").append(iTestKind.getId()).append(")");
        }
        return returnThis.toString();
    }
}

