/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.tm4e.core.internal.matcher.Matcher;

public class BalancedBracketSelectors {
    private final Matcher<List<String>>[] balancedBracketScopes;
    private final Matcher<List<String>>[] unbalancedBracketScopes;
    private boolean allowAny = false;

    BalancedBracketSelectors(List<String> balancedBracketScopes, List<String> unbalancedBracketScopes) {
        this.balancedBracketScopes = (Matcher[])balancedBracketScopes.stream().flatMap(selector -> {
            if ("*".equals(selector)) {
                this.allowAny = true;
                return Stream.empty();
            }
            return Matcher.createMatchers(selector).stream();
        }).map(m -> m.matcher).toArray(Matcher[]::new);
        this.unbalancedBracketScopes = (Matcher[])unbalancedBracketScopes.stream().flatMap(selector -> Matcher.createMatchers(selector).stream()).map(m -> m.matcher).toArray(Matcher[]::new);
    }

    boolean matchesAlways() {
        return this.allowAny && this.unbalancedBracketScopes.length == 0;
    }

    boolean matchesNever() {
        return !this.allowAny && this.balancedBracketScopes.length == 0;
    }

    boolean match(List<String> scopes) {
        Matcher<List<String>>[] matcherArray = this.unbalancedBracketScopes;
        int n = this.unbalancedBracketScopes.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher<List<String>> excluder = matcherArray[n2];
            if (excluder.matches(scopes)) {
                return false;
            }
            ++n2;
        }
        matcherArray = this.balancedBracketScopes;
        n = this.balancedBracketScopes.length;
        n2 = 0;
        while (n2 < n) {
            Matcher<List<String>> includer = matcherArray[n2];
            if (includer.matches(scopes)) {
                return true;
            }
            ++n2;
        }
        return this.allowAny;
    }
}

