/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.debug.DebugUtil;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class DebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InputComponent gdbInput = null;
    private IPreferenceStore store = null;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    public boolean performOk() {
        this.store.setValue("corrosion.defaultGdb", this.gdbInput.getValue());
        return true;
    }

    protected Control createContents(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.gdbInput = new InputComponent(container, Messages.DebugPreferencePage_defaultGDB, e -> {
            boolean bl = this.isPageValid();
        });
        this.gdbInput.createComponent();
        this.gdbInput.createFileSelection();
        this.gdbInput.setValue(this.store.getString("corrosion.defaultGdb"));
        Link gdbLink = new Link(container, 0);
        gdbLink.setText(Messages.DebugPreferencePage_seeGDBPage);
        gdbLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IPreferencePageContainer prefContainer = this.getContainer();
            if (prefContainer instanceof IWorkbenchPreferenceContainer var3_4) {
                workbenchPrefContainer.openPage("org.eclipse.cdt.dsf.gdb.ui.preferences", null);
            }
        }));
        gdbLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        return parent;
    }

    private boolean isPageValid() {
        this.setErrorMessage(null);
        String gdbCommand = this.gdbInput.getValue();
        try {
            try {
                LaunchUtils.getGDBVersion((String)gdbCommand, (String[])new String[0]);
            }
            catch (CoreException e) {
                String msg = DebugUtil.getMessageFromGdbExecutionException(e);
                this.setErrorMessage(msg);
                this.getContainer().updateMessage();
                return false;
            }
        }
        finally {
            this.getContainer().updateMessage();
        }
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CorrosionPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        this.gdbInput.setValue(this.store.getDefaultString("corrosion.defaultGdb"));
        super.performDefaults();
    }
}

