/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.sourcelookup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corrosion.sourcelookup.CargoSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

public class CargoSourceLookupDirector
extends CSourceLookupDirector {
    private static Set<String> fSupportedTypes;
    private static Object fSupportedTypesLock;

    static {
        fSupportedTypesLock = new Object();
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new CargoSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        CargoSourceLookupDirector.readSupportedContainerTypes();
        return fSupportedTypes.contains(type.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readSupportedContainerTypes() {
        Object object = fSupportedTypesLock;
        synchronized (object) {
            if (fSupportedTypes == null) {
                fSupportedTypes = new HashSet<String>();
                String name = "org.eclipse.corrosion.supportedSourceContainerTypes";
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(name);
                if (extensionPoint != null) {
                    IExtension[] iExtensionArray = extensionPoint.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement configurationElements = iConfigurationElementArray[n4];
                            String id = configurationElements.getAttribute("id");
                            if (id != null) {
                                fSupportedTypes.add(id);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

