/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.AbstractJUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestRequest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.LaunchDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestClasses;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.LeadPipeInputStream;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class LauncherSupport {
    private final LaunchDefinition launchDefinition;
    private final TestExecutionContext testExecutionContext;
    private boolean testsFailed;

    public LauncherSupport(LaunchDefinition definition, TestExecutionContext testExecutionContext) {
        if (definition == null) {
            throw new IllegalArgumentException("Launch definition cannot be null");
        }
        if (testExecutionContext == null) {
            throw new IllegalArgumentException("Test execution context cannot be null");
        }
        this.launchDefinition = definition;
        this.testExecutionContext = testExecutionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws BuildException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.launchDefinition.getClassLoader());
            Launcher launcher = LauncherFactory.create();
            List<TestRequest> requests = this.buildTestRequests();
            for (TestRequest testRequest : requests) {
                try {
                    TestDefinition test = testRequest.getOwner();
                    LauncherDiscoveryRequest request = testRequest.getDiscoveryRequest().build();
                    ArrayList<Listener> testExecutionListeners = new ArrayList<Listener>();
                    Listener firstListener = new Listener(System.out);
                    testExecutionListeners.add(firstListener);
                    testExecutionListeners.addAll(this.getListeners(testRequest, this.launchDefinition.getClassLoader()));
                    PrintStream originalSysOut = System.out;
                    PrintStream originalSysErr = System.err;
                    try {
                        firstListener.switchedSysOutHandle = this.trySwitchSysOutErr(testRequest, StreamType.SYS_OUT, originalSysErr);
                        firstListener.switchedSysErrHandle = this.trySwitchSysOutErr(testRequest, StreamType.SYS_ERR, originalSysErr);
                        launcher.execute(request, testExecutionListeners.toArray(new TestExecutionListener[0]));
                    }
                    finally {
                        try {
                            System.setOut(originalSysOut);
                        }
                        catch (Exception exception) {}
                        try {
                            System.setErr(originalSysErr);
                        }
                        catch (Exception exception) {}
                        try {
                            firstListener.switchedSysOutHandle.ifPresent(h -> {
                                try {
                                    h.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                        }
                        catch (Exception exception) {}
                        try {
                            firstListener.switchedSysErrHandle.ifPresent(h -> {
                                try {
                                    h.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                    this.handleTestExecutionCompletion(test, firstListener.getSummary());
                }
                finally {
                    try {
                        testRequest.close();
                    }
                    catch (Exception e) {
                        this.log("Failed to cleanly close test request", e, 4);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    boolean hasTestFailures() {
        return this.testsFailed;
    }

    private List<TestRequest> buildTestRequests() {
        List<TestDefinition> tests = this.launchDefinition.getTests();
        if (tests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TestRequest> requests = new ArrayList<TestRequest>();
        for (TestDefinition test : tests) {
            if (!(test instanceof SingleTestClass) && !(test instanceof TestClasses)) {
                throw new BuildException("Unexpected test definition type " + test.getClass().getName());
            }
            List<TestRequest> testRequests = this.createTestRequests(test);
            if (testRequests == null || testRequests.isEmpty()) continue;
            requests.addAll(testRequests);
        }
        return requests;
    }

    private List<TestExecutionListener> getListeners(TestRequest testRequest, ClassLoader classLoader) {
        TestDefinition test = testRequest.getOwner();
        List<ListenerDefinition> applicableListenerElements = test.getListeners().isEmpty() ? this.launchDefinition.getListeners() : test.getListeners();
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>();
        Optional<Project> project = this.testExecutionContext.getProject();
        for (ListenerDefinition applicableListener : applicableListenerElements) {
            if (project.isPresent() && !applicableListener.shouldUse(project.get())) {
                this.log("Excluding listener " + applicableListener.getClassName() + " since it's not applicable in the context of project", null, 4);
                continue;
            }
            TestExecutionListener listener = this.requireTestExecutionListener(applicableListener, classLoader);
            if (listener instanceof TestResultFormatter) {
                this.setupResultFormatter(testRequest, applicableListener, (TestResultFormatter)listener);
            }
            listeners.add(listener);
        }
        return listeners;
    }

    private void setupResultFormatter(TestRequest testRequest, ListenerDefinition formatterDefinition, TestResultFormatter resultFormatter) {
        testRequest.closeUponCompletion(resultFormatter);
        resultFormatter.setContext(this.testExecutionContext);
        resultFormatter.setUseLegacyReportingName(formatterDefinition.isUseLegacyReportingName());
        Path resultOutputFile = this.getListenerOutputFile(testRequest, formatterDefinition);
        try {
            OutputStream resultOutputStream = Files.newOutputStream(resultOutputFile, new OpenOption[0]);
            testRequest.closeUponCompletion(resultOutputStream);
            resultFormatter.setDestination((OutputStream)new KeepAliveOutputStream(resultOutputStream));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        if (formatterDefinition.shouldSendSysOut()) {
            testRequest.addSysOutInterest(resultFormatter);
        }
        if (formatterDefinition.shouldSendSysErr()) {
            testRequest.addSysErrInterest(resultFormatter);
        }
    }

    private Path getListenerOutputFile(TestRequest testRequest, ListenerDefinition listener) {
        String filename;
        TestDefinition test = testRequest.getOwner();
        if (listener.getResultFile() != null) {
            filename = listener.getResultFile();
        } else {
            StringBuilder sb = new StringBuilder("TEST-");
            sb.append(testRequest.getName() == null ? "unknown" : testRequest.getName());
            sb.append(".");
            String suffix = "org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyXmlResultFormatter".equals(listener.getClassName()) ? "xml" : "txt";
            sb.append(suffix);
            filename = sb.toString();
        }
        if (listener.getOutputDir() != null) {
            return Paths.get(listener.getOutputDir(), filename);
        }
        if (test.getOutputDir() != null) {
            return Paths.get(test.getOutputDir(), filename);
        }
        TestExecutionContext testExecutionContext = this.testExecutionContext;
        String baseDir = testExecutionContext.getProperties().getProperty("basedir");
        return Paths.get(baseDir, filename);
    }

    private TestExecutionListener requireTestExecutionListener(ListenerDefinition listener, ClassLoader classLoader) {
        Class<?> klass;
        String className = listener.getClassName();
        if (className == null || className.trim().isEmpty()) {
            throw new BuildException("classname attribute value is missing on listener element");
        }
        try {
            klass = Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Failed to load listener class " + className, (Throwable)e);
        }
        if (!TestExecutionListener.class.isAssignableFrom(klass)) {
            throw new BuildException("Listener class " + className + " is not of type " + TestExecutionListener.class.getName());
        }
        try {
            return (TestExecutionListener)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BuildException("Failed to create an instance of listener " + className, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTestExecutionCompletion(TestDefinition test, TestExecutionSummary summary) {
        boolean hasTestFailures;
        boolean bl = hasTestFailures = summary.getTotalFailureCount() != 0L;
        if (hasTestFailures) {
            this.testsFailed = true;
        }
        try {
            TestExecutionContext testExecutionContext;
            if (hasTestFailures && test.getFailureProperty() != null && (testExecutionContext = this.testExecutionContext).getProject().isPresent()) {
                Project project = testExecutionContext.getProject().get();
                project.setNewProperty(test.getFailureProperty(), "true");
            }
        }
        finally {
            if (hasTestFailures && test.isHaltOnFailure()) {
                String errorMessage = test instanceof NamedTest ? "Test " + ((NamedTest)((Object)test)).getName() + " has " + summary.getTestsFailedCount() + " failure(s)" : "Some test(s) have failure(s)";
                throw new BuildException(errorMessage);
            }
        }
    }

    private Optional<SwitchedStreamHandle> trySwitchSysOutErr(TestRequest testRequest, StreamType streamType, PrintStream originalSysErr) {
        SysOutErrStreamReader streamer;
        LeadPipeInputStream pipedInputStream;
        switch (streamType) {
            case SYS_OUT: {
                if (testRequest.interestedInSysOut()) break;
                return Optional.empty();
            }
            case SYS_ERR: {
                if (testRequest.interestedInSysErr()) break;
                return Optional.empty();
            }
            default: {
                return Optional.empty();
            }
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            pipedInputStream = new LeadPipeInputStream(pipedOutputStream);
        }
        catch (IOException ioe) {
            return Optional.empty();
        }
        PrintStream printStream = new PrintStream(pipedOutputStream, true);
        switch (streamType) {
            case SYS_OUT: {
                System.setOut(new PrintStream(printStream));
                streamer = new SysOutErrStreamReader(this, (InputStream)pipedInputStream, StreamType.SYS_OUT, testRequest.getSysOutInterests(), originalSysErr);
                Thread sysOutStreamer = new Thread(streamer);
                sysOutStreamer.setDaemon(true);
                sysOutStreamer.setName("junitlauncher-sysout-stream-reader");
                sysOutStreamer.setUncaughtExceptionHandler((t, e) -> {
                    originalSysErr.println("Failed in sysout streaming");
                    e.printStackTrace(originalSysErr);
                });
                sysOutStreamer.start();
                break;
            }
            case SYS_ERR: {
                System.setErr(new PrintStream(printStream));
                streamer = new SysOutErrStreamReader(this, (InputStream)pipedInputStream, StreamType.SYS_ERR, testRequest.getSysErrInterests(), originalSysErr);
                Thread sysErrStreamer = new Thread(streamer);
                sysErrStreamer.setDaemon(true);
                sysErrStreamer.setName("junitlauncher-syserr-stream-reader");
                sysErrStreamer.setUncaughtExceptionHandler((t, e) -> {
                    originalSysErr.println("Failed in syserr streaming");
                    e.printStackTrace(originalSysErr);
                });
                sysErrStreamer.start();
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(new SwitchedStreamHandle(pipedOutputStream, streamer));
    }

    private void log(String message, Throwable t, int level) {
        TestExecutionContext testExecutionContext = this.testExecutionContext;
        if (testExecutionContext.getProject().isPresent()) {
            testExecutionContext.getProject().get().log(message, t, level);
            return;
        }
        if (t == null) {
            System.out.println(message);
        } else {
            System.err.println(message);
            t.printStackTrace();
        }
    }

    private List<TestRequest> createTestRequests(TestDefinition test) {
        if (test instanceof SingleTestClass) {
            SingleTestClass singleTestClass = (SingleTestClass)test;
            LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
            TestRequest request = new TestRequest(test, requestBuilder);
            request.setName(singleTestClass.getName());
            String[] methods = singleTestClass.getMethods();
            if (methods == null) {
                requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)singleTestClass.getName())});
            } else {
                for (String method : methods) {
                    requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((String)singleTestClass.getName(), (String)method)});
                }
            }
            this.addFilters(request);
            return Collections.singletonList(request);
        }
        if (test instanceof TestClasses) {
            List<String> testClasses = ((TestClasses)test).getTestClassNames();
            if (testClasses.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TestRequest> requests = new ArrayList<TestRequest>();
            for (String testClass : testClasses) {
                LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
                TestRequest request = new TestRequest(test, requestBuilder);
                request.setName(testClass);
                requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)testClass)});
                this.addFilters(request);
                requests.add(request);
            }
            return requests;
        }
        return Collections.emptyList();
    }

    private void addFilters(TestRequest testRequest) {
        String[] enginesToExclude;
        LauncherDiscoveryRequestBuilder requestBuilder = testRequest.getDiscoveryRequest();
        String[] enginesToInclude = testRequest.getOwner().getIncludeEngines();
        if (enginesToInclude != null && enginesToInclude.length > 0) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines((String[])enginesToInclude)});
        }
        if ((enginesToExclude = testRequest.getOwner().getExcludeEngines()) != null && enginesToExclude.length > 0) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines((String[])enginesToExclude)});
        }
        if (this.launchDefinition.getIncludeTags().size() > 0) {
            requestBuilder.filters(new Filter[]{TagFilter.includeTags(this.launchDefinition.getIncludeTags())});
        }
        if (this.launchDefinition.getExcludeTags().size() > 0) {
            requestBuilder.filters(new Filter[]{TagFilter.excludeTags(this.launchDefinition.getExcludeTags())});
        }
    }

    private final class Listener
    extends SummaryGeneratingListener {
        private final PrintStream originalSysOut;
        private Optional<SwitchedStreamHandle> switchedSysOutHandle;
        private Optional<SwitchedStreamHandle> switchedSysErrHandle;
        private static final double ONE_SECOND = 1000.0;
        private NumberFormat timeFormatter = NumberFormat.getInstance();

        private Listener(PrintStream originalSysOut) {
            this.originalSysOut = originalSysOut;
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            super.executionStarted(testIdentifier);
            AbstractJUnitResultFormatter.isTestClass(testIdentifier).ifPresent(testClass -> this.originalSysOut.println("Running " + testClass.getClassName()));
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            super.testPlanExecutionFinished(testPlan);
            if (!testPlan.containsTests()) {
                return;
            }
            if (LauncherSupport.this.launchDefinition.isPrintSummary()) {
                TestExecutionSummary summary = this.getSummary();
                StringBuilder sb = new StringBuilder("Tests run: ");
                sb.append(summary.getTestsStartedCount());
                sb.append(", Failures: ");
                sb.append(summary.getTestsFailedCount());
                sb.append(", Aborted: ");
                sb.append(summary.getTestsAbortedCount());
                sb.append(", Skipped: ");
                sb.append(summary.getTestsSkippedCount());
                sb.append(", Time elapsed: ");
                long elapsedMs = summary.getTimeFinished() - summary.getTimeStarted();
                sb.append(this.timeFormatter.format((double)elapsedMs / 1000.0));
                sb.append(" sec");
                this.originalSysOut.println(sb.toString());
            }
            if (this.switchedSysOutHandle.isPresent()) {
                SwitchedStreamHandle sysOut = this.switchedSysOutHandle.get();
                try {
                    this.closeAndWait(sysOut);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.switchedSysErrHandle.isPresent()) {
                SwitchedStreamHandle sysErr = this.switchedSysErrHandle.get();
                try {
                    this.closeAndWait(sysErr);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void closeAndWait(SwitchedStreamHandle handle) throws InterruptedException {
            FileUtils.close((OutputStream)handle.outputStream);
            if (handle.streamReader.contentDeliverer == null) {
                return;
            }
            handle.streamReader.contentDeliverer.completionLatch.await(2L, TimeUnit.SECONDS);
        }
    }

    private final class SwitchedStreamHandle
    implements AutoCloseable {
        private final PipedOutputStream outputStream;
        private final SysOutErrStreamReader streamReader;

        SwitchedStreamHandle(PipedOutputStream outputStream, SysOutErrStreamReader streamReader) {
            this.streamReader = streamReader;
            this.outputStream = outputStream;
        }

        @Override
        public void close() throws Exception {
            this.outputStream.close();
            this.streamReader.sourceStream.close();
        }
    }

    private static final class SysOutErrContentDeliverer
    implements Runnable {
        private volatile boolean stop;
        private final Collection<TestResultFormatter> resultFormatters;
        private final StreamType streamType;
        private final BlockingQueue<byte[]> availableData = new LinkedBlockingQueue<byte[]>();
        private final CountDownLatch completionLatch = new CountDownLatch(1);

        SysOutErrContentDeliverer(StreamType streamType, Collection<TestResultFormatter> resultFormatters) {
            this.streamType = streamType;
            this.resultFormatters = resultFormatters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    byte[] streamData;
                    try {
                        streamData = this.availableData.poll(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.completionLatch.countDown();
                        return;
                    }
                    if (streamData == null) continue;
                    this.deliver(streamData);
                }
                ArrayList remaining = new ArrayList();
                this.availableData.drainTo(remaining);
                if (!remaining.isEmpty()) {
                    for (byte[] data : remaining) {
                        this.deliver(data);
                    }
                }
            }
            finally {
                this.completionLatch.countDown();
            }
        }

        private void deliver(byte[] data) {
            if (data == null || data.length == 0) {
                return;
            }
            for (TestResultFormatter resultFormatter : this.resultFormatters) {
                switch (this.streamType) {
                    case SYS_OUT: {
                        resultFormatter.sysOutAvailable(data);
                        break;
                    }
                    case SYS_ERR: {
                        resultFormatter.sysErrAvailable(data);
                    }
                }
            }
        }
    }

    private static final class SysOutErrStreamReader
    implements Runnable {
        private static final byte[] EMPTY = new byte[0];
        private final LauncherSupport launchManager;
        private final PrintStream originalSysErr;
        private final InputStream sourceStream;
        private final StreamType streamType;
        private final Collection<TestResultFormatter> resultFormatters;
        private volatile SysOutErrContentDeliverer contentDeliverer;

        SysOutErrStreamReader(LauncherSupport launchManager, InputStream source, StreamType streamType, Collection<TestResultFormatter> resultFormatters, PrintStream originalSysErr) {
            this.launchManager = launchManager;
            this.sourceStream = source;
            this.streamType = streamType;
            this.resultFormatters = resultFormatters;
            this.originalSysErr = originalSysErr;
        }

        @Override
        public void run() {
            SysOutErrContentDeliverer streamContentDeliver = new SysOutErrContentDeliverer(this.streamType, this.resultFormatters);
            Thread deliveryThread = new Thread(streamContentDeliver);
            deliveryThread.setName("junitlauncher-" + (this.streamType == StreamType.SYS_OUT ? "sysout" : "syserr") + "-stream-deliverer");
            deliveryThread.setDaemon(true);
            deliveryThread.start();
            this.contentDeliverer = streamContentDeliver;
            int numRead = -1;
            byte[] data = new byte[1024];
            try {
                while ((numRead = this.sourceStream.read(data)) != -1) {
                    byte[] copy = Arrays.copyOf(data, numRead);
                    streamContentDeliver.availableData.offer(copy);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                streamContentDeliver.stop = true;
                streamContentDeliver.availableData.offer(EMPTY);
            }
        }
    }

    private static enum StreamType {
        SYS_OUT,
        SYS_ERR;

    }
}

