/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.process.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProcessHelper {
    public static final String CONDITION = "condition";
    public static final String START_PATTERN = "$(";
    public static final String END_PATTERN = ")";
    public static final String EQUALS = "==";
    public static final String NOT_EQUALS = "!=";

    public static void appendFile(String fileContents, File toFile) throws IOException {
        RandomAccessFile raf = null;
        if (!toFile.exists()) {
            throw new FileNotFoundException(MessageFormat.format(Messages.getString("ProcessHelper.fileNotFound"), toFile.getPath()));
        }
        try {
            raf = new RandomAccessFile(toFile, "rw");
            raf.skipBytes((int)raf.length());
            raf.writeBytes(fileContents);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public static Set<String> getReplaceKeys(String str) {
        return ProcessHelper.getReplaceKeys(str, START_PATTERN, END_PATTERN);
    }

    public static Set<String> getReplaceKeys(String str, String startPattern, String endPattern) {
        HashSet<String> replaceStrings = new HashSet<String>();
        int start = 0;
        int end = 0;
        while ((start = str.indexOf(startPattern, start)) >= 0) {
            end = str.indexOf(endPattern, start);
            if (end != -1) {
                replaceStrings.add(str.substring(start + startPattern.length(), end));
                start = end + endPattern.length();
                continue;
            }
            ++start;
        }
        return replaceStrings;
    }

    public static String readFromFile(URL source) throws IOException {
        int c;
        char[] chars = new char[4092];
        InputStreamReader contentsReader = null;
        StringBuilder buffer = new StringBuilder();
        if (!new File(source.getFile()).exists()) {
            throw new FileNotFoundException(MessageFormat.format(Messages.getString("ProcessHelper.fileNotFound"), source.getFile()));
        }
        contentsReader = new InputStreamReader(source.openStream());
        while ((c = contentsReader.read(chars)) != -1) {
            buffer.append(chars, 0, c);
            if (c != -1) continue;
        }
        contentsReader.close();
        return buffer.toString();
    }

    public static void copyBinaryFile(URL source, File dest) throws IOException {
        File file;
        byte[] bytes = new byte[4092];
        if (source != null && dest != null && (file = new File(source.getFile())).isFile()) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(file);
                out = new FileOutputStream(dest);
                while ((len = in.read(bytes)) != -1) {
                    out.write(bytes, 0, len);
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    public static void mkdirs(IProject projectHandle, IFolder parentFolder) throws CoreException {
        if (parentFolder.getProjectRelativePath().equals((Object)projectHandle.getProjectRelativePath())) {
            return;
        }
        if (!parentFolder.getParent().exists()) {
            ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(parentFolder.getParent().getProjectRelativePath()));
        }
        parentFolder.create(true, true, null);
    }

    public static String getValueAfterExpandingMacros(String string, Set<String> macros, Map<String, String> valueStore) {
        return ProcessHelper.getValueAfterExpandingMacros(string, macros, valueStore, START_PATTERN, END_PATTERN);
    }

    public static String getValueAfterExpandingMacros(String string, Set<String> macros, Map<String, String> valueStore, String startPattern, String endPattern) {
        for (String key : macros) {
            String value = valueStore.get(key);
            if (value == null) continue;
            string = string.replace(String.valueOf(startPattern) + key + endPattern, value);
        }
        return string;
    }

    public static String getReplaceMarker(String macro) {
        return START_PATTERN + macro + END_PATTERN;
    }
}

