/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tools.templates.core.IGenerator;
import org.eclipse.tools.templates.ui.Messages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.osgi.framework.FrameworkUtil;

public abstract class ProjectImportConfigurator
implements ProjectConfigurator {
    protected abstract List<String> getProjectFileNames();

    protected abstract IGenerator getGenerator(IProject var1);

    private List<PathMatcher> createPathMatchers(List<String> globs) {
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(FileSystems.getDefault().getPathMatcher("glob:" + glob));
        }
        return matchers;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        List<PathMatcher> matchers = this.createPathMatchers(this.getProjectFileNames());
        Collector c = new Collector(matchers, monitor);
        try {
            Files.walkFileTree(root.toPath(), c);
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return c.getCollected();
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        List<PathMatcher> matchers = this.createPathMatchers(this.getProjectFileNames());
        File location = container.getLocation().toFile();
        File[] fileArray = location.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && matchers.stream().anyMatch(p -> p.matches(f.toPath().getFileName()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return Set.of();
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        try {
            IGenerator generator = this.getGenerator(project);
            generator.generate(monitor);
        }
        catch (CoreException e) {
            Status status = new Status(e.getStatus().getSeverity(), FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), e.getLocalizedMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 3);
        }
    }

    private static class Collector
    extends SimpleFileVisitor<Path> {
        private IProgressMonitor monitor;
        private List<PathMatcher> matchers;
        private Set<File> locations = new LinkedHashSet<File>();

        private Collector(List<PathMatcher> matchers, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.matchers = matchers;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.monitor.isCanceled()) {
                return FileVisitResult.TERMINATE;
            }
            this.monitor.subTask(MessageFormat.format(Messages.ProjectImportConfigurator_Checking, dir));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path name = file.getFileName();
            boolean match = this.matchers.stream().anyMatch(p -> p.matches(name));
            if (match) {
                this.locations.add(file.getParent().toFile());
            }
            return FileVisitResult.CONTINUE;
        }

        public Set<File> getCollected() {
            return this.locations;
        }
    }
}

