/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPUsingDirective
implements ICPPUsingDirective {
    private IASTName fNamespaceName;

    public CPPUsingDirective(ICPPASTUsingDirective node) {
        this.fNamespaceName = node.getQualifiedName();
    }

    public CPPUsingDirective(ICPPASTNamespaceDefinition nsdef) {
        this.fNamespaceName = nsdef.getName();
    }

    @Override
    public ICPPNamespaceScope getNominatedScope() throws DOMException {
        IBinding binding = this.fNamespaceName.resolveBinding();
        if (binding instanceof ICPPNamespace) {
            return ((ICPPNamespace)binding).getNamespaceScope();
        }
        return null;
    }

    @Override
    public int getPointOfDeclaration() {
        ASTNode astNode = (ASTNode)((Object)this.fNamespaceName);
        return astNode.getOffset() + astNode.getLength();
    }

    @Override
    public IScope getContainingScope() {
        return CPPVisitor.getContainingScope(this.fNamespaceName);
    }

    public String toString() {
        return "using namespace " + this.fNamespaceName.toString();
    }
}

