/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleConsumer;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class RustManager {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    static final File RUST_ANALYZER_DEFAULT_LOCATION = new File(System.getProperty("user.home"), ".local/bin/rust-analyzer");
    public static final String RLS_VERSION_FORMAT_REGEX = "^(rls|rust-analyzer).*$";
    public static final String CARGO_VERSION_FORMAT_REGEX = "^cargo .*$";
    public static final String RUSTUP_VERSION_FORMAT_REGEX = "^rustup .*$";
    public static final Pattern RLS_VERSION_FORMAT_PATTERN = Pattern.compile("^(rls|rust-analyzer).*$");
    public static final Pattern CARGO_VERSION_FORMAT_PATTERN = Pattern.compile("^cargo .*$");
    public static final Pattern RUSTUP_VERSION_FORMAT_PATTERN = Pattern.compile("^rustup .*$");
    private static final String RUST_ANALIZER_BASE_URL = "https://github.com/rust-analyzer/rust-analyzer/releases/latest/download/";
    private static Job settingToolchainJob = null;

    private RustManager() {
        throw new IllegalStateException("Utility class");
    }

    public static String getDefaultDebugger() {
        return STORE.getString("corrosion.defaultGdb");
    }

    /*
     * Unable to fully structure code
     */
    public static String getDefaultToolchain() {
        block20: {
            rustup = RustManager.STORE.getString("corrosion.rustup_rustupPath");
            emptyResult = "";
            if (rustup.isEmpty()) {
                return "";
            }
            process = CorrosionPlugin.getProcessForCommand(new String[]{rustup, "show"});
            if (process.waitFor() == 0) break block20;
            return "";
        }
        try {
            var3_5 = null;
            var4_7 = null;
            try {
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    line = in.readLine();
                    while (true) {
                        if (line.matches("^.*\\(default\\)$")) {
                            if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                                return line.substring(0, 18);
                            }
                            splitIndex = line.indexOf(45);
                            if (splitIndex != -1) {
                                return line.substring(0, splitIndex);
                            }
                            return line;
                        }
                        line = in.readLine();
                        return line;
                    }
                }
                finally {
                    if (line != null) ** continue;
                }
            }
            catch (Throwable var4_8) {
                if (var3_5 == null) {
                    var3_5 = var4_8;
                } else if (var3_5 != var4_8) {
                    var3_5.addSuppressed(var4_8);
                }
                throw var3_5;
            }
        }
        catch (IOException e) {
            CorrosionPlugin.logError(e);
            return "";
        }
        catch (InterruptedException e) {
            CorrosionPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        return "";
    }

    public static synchronized Job setDefaultToolchain(final String toolchainId) {
        if (settingToolchainJob != null) {
            settingToolchainJob.cancel();
        }
        settingToolchainJob = new Job(Messages.RustManager_settingRLSToolchain){
            CommandJob currentCommandJob;

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<CommandJob> jobs = new ArrayList<CommandJob>();
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_installingToolchain, NLS.bind((String)Messages.RustManager_unableToInstallToolchain, (Object)toolchainId), "toolchain", "install", toolchainId));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_settingDefaultToolchain, NLS.bind((String)Messages.RustManager_unableToSetDefaultToolchain, (Object)toolchainId), "default", toolchainId));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_addingRustAnalysisRustSrc, Messages.RustManager_unableToAddComponent, "component", "add", "rust-analysis"));
                Iterator iterator = jobs.iterator();
                while (iterator.hasNext()) {
                    CommandJob commandJob;
                    this.currentCommandJob = commandJob = (CommandJob)((Object)iterator.next());
                    if (this.currentCommandJob.run(monitor) == Status.CANCEL_STATUS) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                HashMap<String, String> updatedSettings = new HashMap<String, String>();
                updatedSettings.put("target", toolchainId);
                RustManager.sendDidChangeConfigurationsMessage(updatedSettings);
                return Status.OK_STATUS;
            }

            protected void canceling() {
                if (this.currentCommandJob != null) {
                    this.currentCommandJob.cancel();
                }
            }
        };
        settingToolchainJob.schedule();
        return settingToolchainJob;
    }

    private static void sendDidChangeConfigurationsMessage(Map<String, String> updatedSettings) {
        DidChangeConfigurationParams params = new DidChangeConfigurationParams();
        params.setSettings(updatedSettings);
        LanguageServiceAccessor.LSPDocumentInfo info = RustManager.infoFromOpenEditors();
        if (info != null) {
            info.getInitializedLanguageClient().thenAccept(languageServer -> languageServer.getWorkspaceService().didChangeConfiguration(params));
        }
    }

    public static CommandJob createRustupCommandJob(String progressMessage, String errorMessage, String ... arguments) {
        String rustup = STORE.getString("corrosion.rustup_rustupPath");
        if (rustup.isEmpty()) {
            return null;
        }
        String[] command = new String[arguments.length + 1];
        command[0] = rustup;
        System.arraycopy(arguments, 0, command, 1, arguments.length);
        return new CommandJob(command, progressMessage, Messages.RustManager_rootToolchainSelectionFailure, errorMessage, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static LanguageServiceAccessor.LSPDocumentInfo infoFromOpenEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    block6: {
                        void textEditor;
                        IDocument document;
                        List infos;
                        IEditorPart iEditorPart;
                        IEditorInput input;
                        IEditorReference editor = iEditorReferenceArray[n6];
                        try {
                            input = editor.getEditorInput();
                        }
                        catch (PartInitException e) {
                            break block6;
                        }
                        if (input.getName().endsWith(".rs") && (iEditorPart = editor.getEditor(false)) instanceof ITextEditor && (e = (ITextEditor)iEditorPart) == (ITextEditor)iEditorPart && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)(document = textEditor.getDocumentProvider().getDocument((Object)input)), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider().get()))).isEmpty()) {
                            return (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getToolchains() {
        ArrayList<String> toolchainsList = new ArrayList<String>();
        String rustup = STORE.getString("corrosion.rustup_rustupPath");
        if (rustup.isEmpty()) {
            return toolchainsList;
        }
        try {
            Process process = CorrosionPlugin.getProcessForCommand(rustup, "show");
            if (process.waitFor() != 0) {
                return toolchainsList;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = in.readLine();
                while (line != null && !line.equals("active toolchain")) {
                    int splitIndex;
                    String toolchain = "";
                    if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                        toolchain = line.substring(0, 18);
                    } else if (line.matches("\\w+\\-.*") && (splitIndex = line.indexOf(45)) != -1) {
                        toolchain = line.substring(0, splitIndex);
                    }
                    if (!toolchain.isEmpty()) {
                        toolchainsList.add(toolchain);
                    }
                    line = in.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CorrosionPlugin.logError(e);
        }
        return toolchainsList;
    }

    public static boolean setSystemProperties() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        String sysrootPath = preferenceStore.getString("corrosion.sysrootPath");
        if (sysrootPath == null || sysrootPath.isBlank()) {
            String rustup = preferenceStore.getString("corrosion.rustup_rustupPath");
            String toolchain = preferenceStore.getString("corrosion.rustup_toolchain_Id");
            if (!rustup.isEmpty() && !toolchain.isEmpty()) {
                String[] command = new String[]{rustup, "run", toolchain, "rustc", "--print", "sysroot"};
                sysrootPath = CorrosionPlugin.getOutputFromCommand(command);
            }
        }
        if (sysrootPath != null && !sysrootPath.isEmpty()) {
            System.setProperty("SYS_ROOT", sysrootPath);
            System.setProperty("LD_LIBRARY_PATH", String.valueOf(sysrootPath) + "/lib");
            String sysRoot = System.getProperty("SYS_ROOT");
            String ldLibraryPath = System.getProperty("LD_LIBRARY_PATH");
            if (sysRoot != null && !sysRoot.isEmpty() && ldLibraryPath != null && !ldLibraryPath.isEmpty()) {
                return true;
            }
        }
        CorrosionPlugin.getDefault().getLog().log(Status.error((String)Messages.RLSStreamConnectionProvider_unableToSet));
        return false;
    }

    public static File getLanguageServerConfiguration() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        String preferencePath = preferenceStore.getString("corrosion.rls_configurationPath");
        if (preferencePath.isEmpty()) {
            CorrosionPlugin.getDefault().getLog().log(Status.warning((String)Messages.RLSStreamConnectionProvider_rlsConfigurationNotSet));
            return null;
        }
        return new File(preferencePath);
    }

    public static File getLanguageServerExecutable() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        String rlsPath = preferenceStore.getString("corrosion.rslPath");
        if (rlsPath.isEmpty()) {
            CorrosionPlugin.getDefault().getLog().log(Status.error((String)Messages.RLSStreamConnectionProvider_rlsNotFound));
            return null;
        }
        return new File(rlsPath);
    }

    public static CompletableFuture<File> downloadAndInstallRustAnalyzer(DoubleConsumer progressConsumer) {
        if (!RUST_ANALYZER_DEFAULT_LOCATION.getParentFile().exists()) {
            RUST_ANALYZER_DEFAULT_LOCATION.getParentFile().mkdirs();
        }
        String filename = "rust-analyzer-" + ("aarch64".equals(Platform.getOSArch()) ? "aarch64-" : ("x86_64".equals(Platform.getOSArch()) ? "x86_64-" : "arch-not-found")) + ("linux".equals(Platform.getOS()) ? "unknown-linux-gnu.gz" : ("win32".equals(Platform.getOS()) ? "pc-windows-msvc.gz" : ("macosx".equals(Platform.getOS()) ? "apple-darwin.gz" : "os-not-found")));
        String url = RUST_ANALIZER_BASE_URL + filename;
        IRetrieveFileTransfer retrieve = CorrosionPlugin.getDefault().getFileTransferService();
        File archiveFile = new File(RUST_ANALYZER_DEFAULT_LOCATION.getParentFile(), filename);
        try {
            CompletableFuture<File> res = new CompletableFuture<File>();
            IFileID id = FileIDFactory.getDefault().createFileID(retrieve.getRetrieveNamespace(), URI.create(url));
            IFileTransferListener listener = event -> {
                if (event instanceof IIncomingFileTransferReceiveStartEvent var4_5) {
                    try {
                        rse.receive(archiveFile);
                    }
                    catch (IOException e) {
                        res.completeExceptionally(e);
                    }
                } else {
                    if (event instanceof IIncomingFileTransferReceiveDataEvent e) {
                        progressConsumer.accept(receiveEvent.getSource().getPercentComplete());
                    } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                        try {
                            RustManager.decompressGzip(archiveFile, RUST_ANALYZER_DEFAULT_LOCATION);
                            res.complete(RUST_ANALYZER_DEFAULT_LOCATION);
                        }
                        catch (IOException e) {
                            res.completeExceptionally(e);
                        }
                    }
                }
            };
            res.exceptionally(e -> {
                CorrosionPlugin.logError("Could not download " + url);
                CorrosionPlugin.logError(e);
                return null;
            });
            retrieve.sendRetrieveRequest(id, listener, Map.of());
            return res;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return CompletableFuture.failedFuture(e2);
        }
    }

    public static void decompressGzip(File input, File output) throws IOException {
        output.delete();
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(input));){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FileOutputStream out = new FileOutputStream(output);){
                in.transferTo(out);
                output.setExecutable(true);
                input.delete();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

