/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.resources;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;

public class FileRelevance {
    private static final int PREFERRED_PROJECT = 64;
    private static final int LINK_PENALTY = 1;
    private static final int INACCESSIBLE_SHIFT = 4;

    public static int getRelevance(IFile f, IProject preferredProject) {
        return FileRelevance.getRelevance(f, preferredProject, true, null);
    }

    public static int getRelevance(IFile f, IProject preferredProject, boolean degradeSymLinks, Object originalLocation) {
        int result = 0;
        IProject p = f.getProject();
        if (p.equals((Object)preferredProject)) {
            result += 64;
        }
        if (!f.isAccessible()) {
            result >>= 4;
        } else if (f.isLinked()) {
            --result;
        } else if (degradeSymLinks) {
            ResourceAttributes ra = f.getResourceAttributes();
            if (ra != null && ra.isSymbolicLink()) {
                --result;
            }
        } else if (originalLocation instanceof URI) {
            if (originalLocation.equals(f.getLocationURI())) {
                ++result;
            }
        } else if (originalLocation instanceof IPath && originalLocation.equals(f.getLocation())) {
            ++result;
        }
        return result;
    }
}

