/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.debugview.layout.actions;

import java.util.HashSet;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.provisional.service.IExecutionContextTranslator;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public abstract class DsfDebugViewLayoutCommand
implements IDebugCommandHandler {
    protected final DsfExecutor fExecutor;
    protected final DsfServicesTracker fTracker;
    protected static IRunControl.IExecutionDMContext[] EMPTY_ARRAY = new IRunControl.IExecutionDMContext[0];

    public DsfDebugViewLayoutCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected IRunControl.IExecutionDMContext[] getDMContexts(IDebugCommandRequest request) {
        HashSet<IRunControl.IExecutionDMContext> ret = new HashSet<IRunControl.IExecutionDMContext>();
        String sessionId = null;
        Object[] objectArray = request.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof IDMVMContext)) {
                return EMPTY_ARRAY;
            }
            IDMContext dmContext = ((IDMVMContext)obj).getDMContext();
            IRunControl.IExecutionDMContext exeContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, IRunControl.IExecutionDMContext.class);
            if (exeContext == null) {
                return EMPTY_ARRAY;
            }
            if (sessionId == null) {
                sessionId = dmContext.getSessionId();
            } else if (!sessionId.equals(dmContext.getSessionId())) {
                return EMPTY_ARRAY;
            }
            ret.add(exeContext);
            ++n2;
        }
        return ret.toArray(new IRunControl.IExecutionDMContext[ret.size()]);
    }

    public void canExecute(final IEnabledStateRequest request) {
        final IRunControl.IExecutionDMContext[] executionContexts = this.getDMContexts((IDebugCommandRequest)request);
        if (executionContexts.length > 0 && !this.fExecutor.isTerminated()) {
            this.fExecutor.submit((Runnable)new DsfRunnable(){

                public void run() {
                    IExecutionContextTranslator translator = (IExecutionContextTranslator)DsfDebugViewLayoutCommand.this.fTracker.getService(IExecutionContextTranslator.class);
                    if (translator != null) {
                        DsfDebugViewLayoutCommand.this.canExecuteOnDsfThread(translator, executionContexts, new DataRequestMonitor<Boolean>((Executor)DsfDebugViewLayoutCommand.this.fExecutor, null){

                            protected void handleCompleted() {
                                boolean canExecute = this.isSuccess() && (Boolean)this.getData() != false;
                                request.setEnabled(canExecute);
                                request.done();
                            }
                        });
                    } else {
                        request.setEnabled(false);
                        request.done();
                    }
                }
            });
        } else {
            request.setEnabled(false);
            request.done();
        }
    }

    public boolean execute(final IDebugCommandRequest request) {
        final IRunControl.IExecutionDMContext[] executionContexts = this.getDMContexts(request);
        if (executionContexts.length > 0 && !this.fExecutor.isTerminated()) {
            this.fExecutor.submit((Runnable)new DsfRunnable(){

                public void run() {
                    IExecutionContextTranslator translator = (IExecutionContextTranslator)DsfDebugViewLayoutCommand.this.fTracker.getService(IExecutionContextTranslator.class);
                    if (translator != null) {
                        DsfDebugViewLayoutCommand.this.executeOnDsfThread(translator, executionContexts, new RequestMonitor((Executor)DsfDebugViewLayoutCommand.this.fExecutor, null){

                            protected void handleCompleted() {
                                request.done();
                            }
                        });
                    } else {
                        request.done();
                    }
                }
            });
            return false;
        }
        request.done();
        return true;
    }

    abstract void executeOnDsfThread(IExecutionContextTranslator var1, IRunControl.IExecutionDMContext[] var2, RequestMonitor var3);

    abstract void canExecuteOnDsfThread(IExecutionContextTranslator var1, IRunControl.IExecutionDMContext[] var2, DataRequestMonitor<Boolean> var3);
}

