/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsByOperatorsWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsTable;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExpressionsByOperatorsPage
extends WizardPage
implements SelectionListener {
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private Composite tablePanel;
    private QueryValueExpression updatedSQLExpression;
    private QueryValueExpression expression;
    private Text previewExpressionText;
    private ExpressionsTable expressionsTable;
    private ExpressionElement elementToUpdate;

    public ExpressionsByOperatorsPage(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_EXPRESSION_BY_OPERATOR_TITLE);
        this.setTitle(Messages._UI_WIZARD_EXPRESSION_BY_OPERATOR_HEADING);
        this.setDescription(Messages._UI_WIZARD_EXPRESSION_BY_OPERATOR_EXPL);
        this.setPageComplete(false);
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.expression = sqlExpr instanceof ValueExpressionCombined ? ExpressionHelper.getLowestLeftChild(sqlExpr) : sqlExpr;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle1000");
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Label infoLabel = new Label(mainPanel, 16640);
        infoLabel.setText(Messages._UI_LABEL_BUILD_LEFT_OP_RIGHT);
        infoLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.tablePanel = new Composite(mainPanel, 0);
        GridLayout tablePanelLayout = new GridLayout();
        tablePanelLayout.marginHeight = 0;
        tablePanelLayout.marginWidth = 0;
        this.tablePanel.setLayout((Layout)tablePanelLayout);
        this.tablePanel.setLayoutData((Object)ViewUtility.createFill());
        if (this.expression == null) {
            this.expression = ExpressionHelper.createExpression();
        }
        this.expressionsTable = new ExpressionsTable(this, this.tablePanel, this.domainModel, this.sqlStatement);
        this.expressionsTable.getTable().setLinesVisible(true);
        this.expressionsTable.getTable().setLayoutData((Object)ViewUtility.createFill());
        this.expressionsTable.setInput(this.expression);
        Label previewFunctionLabel = new Label(mainPanel, 16640);
        previewFunctionLabel.setText(Messages._UI_LABEL_PREVIEW_EXPRESSION);
        this.previewExpressionText = new Text(mainPanel, 2632);
        this.previewExpressionText.setLayoutData((Object)ViewUtility.createFill());
        this.setControl((Control)mainPanel);
    }

    public void setExpression(QueryValueExpression expr) {
        this.expression = expr;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
    }

    public QueryValueExpression getExpression() {
        return this.expression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateFinishButton();
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setElementToUpdate(ExpressionElement element) {
        this.elementToUpdate = element;
    }

    public ExpressionElement getElementToUpdate() {
        return this.elementToUpdate;
    }

    public void updateFinishButton() {
        boolean isComplete = true;
        this.updatePreviewExpressionText();
        QueryValueExpression rootExpr = ExpressionHelper.getRoot(this.expression);
        if (this.expression != null && !ExpressionHelper.isComplete(rootExpr)) {
            isComplete = false;
        }
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(isComplete);
            wiz.setAllPagesComplete(isComplete);
        }
    }

    public boolean performOk() {
        this.updatedSQLExpression = ExpressionHelper.getRoot(this.expression);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof ExpressionsByOperatorsWizard) {
            ExpressionsByOperatorsWizard wiz = (ExpressionsByOperatorsWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        this.expressionsTable = null;
        return true;
    }

    private void updatePreviewExpressionText() {
        if (this.expression != null) {
            QueryValueExpression root = ExpressionHelper.getRoot(this.expression);
            String sql = root.getSQL();
            this.previewExpressionText.setText(sql);
        } else {
            this.previewExpressionText.setText("");
        }
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

