/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSMetadata;
import org.eclipse.datatools.enablement.ibm.util.PRSQueryInfo;
import org.eclipse.datatools.enablement.ibm.util.PersistentResultSetData;
import org.eclipse.datatools.enablement.ibm.util.StringCache;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class PRSDatabaseLoader
extends PersistentResultSetData {
    private final PRSQueryInfo qinfo;
    private QueryDescriptor queryDesc;
    private boolean processingStarted = false;
    private boolean processingComplete = false;
    private int rowsProcessed = 0;
    static int nextqnum = 0;
    static final int QSIZE = 128;
    static int[] rowcount = new int[128];
    static PRSDatabaseLoader[] runningQueries = new PRSDatabaseLoader[128];
    public final int qnum = nextqnum++;
    private static final int CHAR_CONVERSION_EXCEPTION = -4220;

    public PRSDatabaseLoader(PRSQueryInfo qinfo, ICatalogQuery query) {
        this.qinfo = qinfo;
        this.queryDesc = new QueryDescriptor(query);
    }

    public void initiateQuery(Connection connection) {
        try {
            this.processQuery(connection);
            if (this.processingComplete) {
                this.qinfo.loadFinished(this);
            }
        }
        catch (SQLException e) {
            this.qinfo.setException(e);
        }
    }

    public int getRawRowCount() {
        return this.rowsProcessed;
    }

    public Database getDatabase() {
        return this.qinfo.getQueryCache().getDatabase();
    }

    public ICatalogQuery getQuery() {
        return this.qinfo.getQuery();
    }

    private PRSMetadata getMetadata() {
        return this.qinfo.getMetadata();
    }

    public synchronized boolean isComplete() {
        return this.processingComplete;
    }

    public synchronized void close() {
        this.processingComplete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQuery(Connection connection) throws SQLException {
        PRSDatabaseLoader pRSDatabaseLoader = this;
        synchronized (pRSDatabaseLoader) {
            if (this.processingStarted || this.processingComplete) {
                return;
            }
            if (this.queryDesc.queryText == null) {
                this.processingComplete = true;
                return;
            }
            this.processingStarted = true;
        }
        PRSDebug.debugQueryDelay();
        Statement s = null;
        ResultSet r = null;
        try {
            s = connection.createStatement();
            s.setFetchDirection(1000);
            s.setFetchSize(1000);
            if (PRSDebug.enableTracing) {
                PRSDebug.trace("PRS: Running query db=" + this.getDatabase().getName());
                PRSDebug.trace(this.queryDesc.queryText);
            }
            if (PRSDebug.traceQueries) {
                PRSDatabaseLoader.runningQueries[this.qnum % 128] = this;
                System.out.println("\n" + PRSDebug.timestamp() + " Running query " + this.qnum + "\n" + this.queryDesc.queryText);
                this.traceActiveQueries();
            }
            r = s.executeQuery(this.queryDesc.queryText);
            PRSMetadata metadata = this.qinfo.getMetadata();
            if (metadata == null) {
                this.qinfo.setMetadata(new PRSMetadata(r));
            }
        }
        catch (SQLException e) {
            CatalogLoadUtil.safeClose(s, r);
            if (PRSDebug.enableTracing) {
                PRSDebug.trace("Error executing query");
                PRSDebug.trace(this.queryDesc.queryText);
                PRSDebug.trace(e.toString());
            }
            PRSDatabaseLoader pRSDatabaseLoader2 = this;
            synchronized (pRSDatabaseLoader2) {
                this.processingComplete = true;
            }
            this.qinfo.quitOnError(this);
            throw e;
        }
        final Statement fs = s;
        final ResultSet fr = r;
        Thread processRowsWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PRSDatabaseLoader.this.processRows(fr);
                }
                finally {
                    CatalogLoadUtil.safeClose(fs, fr);
                }
                if (PRSDebug.enableTracing) {
                    PRSDebug.trace("PRS: Query worker finished");
                }
            }
        });
        if (PRSDebug.enableTracing) {
            PRSDebug.trace("PRS: Query worker thread id=" + processRowsWorker.getId());
        }
        processRowsWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRows(ResultSet r) {
        block19: {
            try {
                try {
                    while (!this.isComplete() && r.next()) {
                        this.processRow(r);
                    }
                }
                catch (SQLException e) {
                    this.qinfo.setException(e);
                    this.qinfo.quitOnError(this);
                    IBMPluginActivator.log(e);
                    if (PRSDebug.enableTracing) {
                        PRSDebug.trace("Error processing rows for query: count=" + this.rowsProcessed);
                        PRSDebug.trace(this.queryDesc.queryText);
                        PRSDebug.trace(e.toString());
                    }
                    this.qinfo.loadFinished(this);
                    PRSDatabaseLoader pRSDatabaseLoader = this;
                    synchronized (pRSDatabaseLoader) {
                        PRSDatabaseLoader.runningQueries[this.qnum % 128] = null;
                        if (PRSDebug.traceQueries) {
                            System.out.println(String.valueOf(PRSDebug.timestamp()) + " FINISH query#" + this.qnum + " row#" + rowcount[this.qnum % 128]);
                        }
                        this.traceActiveQueries();
                        this.processingComplete = true;
                        this.processingStarted = false;
                        this.notifyAll();
                        break block19;
                    }
                }
            }
            catch (Throwable throwable) {
                this.qinfo.loadFinished(this);
                PRSDatabaseLoader pRSDatabaseLoader = this;
                synchronized (pRSDatabaseLoader) {
                    PRSDatabaseLoader.runningQueries[this.qnum % 128] = null;
                    if (PRSDebug.traceQueries) {
                        System.out.println(String.valueOf(PRSDebug.timestamp()) + " FINISH query#" + this.qnum + " row#" + rowcount[this.qnum % 128]);
                    }
                    this.traceActiveQueries();
                    this.processingComplete = true;
                    this.processingStarted = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            this.qinfo.loadFinished(this);
            PRSDatabaseLoader pRSDatabaseLoader = this;
            synchronized (pRSDatabaseLoader) {
                PRSDatabaseLoader.runningQueries[this.qnum % 128] = null;
                if (PRSDebug.traceQueries) {
                    System.out.println(String.valueOf(PRSDebug.timestamp()) + " FINISH query#" + this.qnum + " row#" + rowcount[this.qnum % 128]);
                }
                this.traceActiveQueries();
                this.processingComplete = true;
                this.processingStarted = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRow(ResultSet r) throws SQLException {
        ++this.rowsProcessed;
        if (PRSDebug.enableTracing) {
            PRSDebug.trace("PRS: processing row " + this.rowsProcessed);
        }
        PRSDebug.debugRowDelay();
        int colcount = this.getMetadata().getColumnCount();
        Object[] row = new Object[colcount + 1];
        int ii = 1;
        while (ii <= colcount) {
            row[ii - 1] = this.getResultValue(r, ii);
            ++ii;
        }
        if (PRSDebug.traceQueries) {
            int n = this.qnum % 128;
            rowcount[n] = rowcount[n] + 1;
        }
        this.qinfo.addRow(row, this);
        PRSDatabaseLoader pRSDatabaseLoader = this;
        synchronized (pRSDatabaseLoader) {
            this.notifyAll();
        }
    }

    private Object getResultValue(ResultSet rs, int ii) throws SQLException {
        Object o = null;
        switch (this.getMetadata().columnInfo[ii - 1].columnType) {
            case 1: 
            case 12: 
            case 2005: {
                try {
                    o = rs.getObject(ii);
                    if (o == null || o instanceof String) break;
                    o = rs.getString(ii);
                    break;
                }
                catch (Exception e) {
                    if (e instanceof SQLException && ((SQLException)e).getErrorCode() == -4220) {
                        o = " ";
                        break;
                    }
                    throw new SQLException("Error getting value for index " + ii, e);
                }
            }
            case -3: 
            case -2: {
                o = rs.getObject(ii);
                break;
            }
            case -5: 
            case 4: 
            case 5: {
                o = rs.getLong(ii);
                break;
            }
            case 6: 
            case 8: {
                o = rs.getDouble(ii);
                break;
            }
            case 3: {
                o = rs.getBigDecimal(ii);
                break;
            }
            case 93: {
                o = rs.getTimestamp(ii);
                break;
            }
            default: {
                o = rs.getString(ii);
            }
        }
        if (o instanceof String) {
            o = StringCache.getUniqueString((String)o);
        }
        return o;
    }

    public synchronized void waitForRow() {
        if (this.isComplete()) {
            return;
        }
        long deadline1 = System.currentTimeMillis() + 10L;
        long deadline2 = System.currentTimeMillis() + 1000L;
        boolean awakened = false;
        long now;
        while (!(deadline2 <= (now = System.currentTimeMillis()) || awakened && deadline1 <= now)) {
            long waittime = deadline1 > now ? deadline1 - now : deadline2 - now;
            try {
                this.wait(waittime);
            }
            catch (InterruptedException interruptedException) {}
            awakened = true;
        }
        return;
    }

    private void traceActiveQueries() {
        if (!PRSDebug.traceQueries) {
            return;
        }
        System.out.print("  Active queries: ");
        int ii = 0;
        while (ii < 128) {
            int idx = ii + nextqnum - 128;
            if (idx >= 0 && runningQueries[idx % 128] != null) {
                int qid = PRSDatabaseLoader.runningQueries[idx % 128].qnum;
                int rows = rowcount[idx % 128];
                System.out.print(String.valueOf(Integer.toString(qid)) + "(" + rows + ")");
            }
            ++ii;
        }
        System.out.println();
    }

    private class QueryDescriptor {
        String queryText;

        public QueryDescriptor(ICatalogQuery query) {
            this.queryText = query.useOnDemandQuery() ? query.generateOnDemandQuery(PRSDatabaseLoader.this.getDatabase()) : query.generateUpFrontQuery(PRSDatabaseLoader.this.getDatabase());
        }
    }
}

