/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceRelatedViewer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class FeaturesViewer
extends TableViewer
implements IDifferenceRelatedViewer {
    private boolean _showAllFeatures;
    private boolean _useTechnicalRepresentation;

    public FeaturesViewer(Composite parent_p) {
        this(parent_p, 770);
    }

    public FeaturesViewer(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._showAllFeatures = false;
        this._useTechnicalRepresentation = false;
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setComparator(new ViewerComparator());
    }

    public EStructuralFeature getFirstIn(FeaturesInput input_p) {
        Object firstElement;
        Object[] elements;
        EStructuralFeature result = null;
        if (input_p != null && (elements = this.getSortedChildren(input_p)) != null && elements.length > 0 && (firstElement = elements[0]) instanceof EStructuralFeature) {
            result = (EStructuralFeature)firstElement;
        }
        return result;
    }

    public FeaturesInput getInput() {
        return (FeaturesInput)super.getInput();
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getContext().getResourceManager();
    }

    @Override
    public boolean isDifferenceAgnostic() {
        return this._showAllFeatures;
    }

    protected boolean isOwnershipFeature(Object object_p) {
        return EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(object_p);
    }

    public boolean isTechnical() {
        return this._useTechnicalRepresentation;
    }

    @Override
    public void setDifferenceAgnostic(boolean agnostic_p) {
        if (agnostic_p != this.isDifferenceAgnostic()) {
            this._showAllFeatures = agnostic_p;
            this.refresh(false);
        }
    }

    public void setTechnical(boolean technical_p) {
        if (technical_p != this.isTechnical()) {
            this._useTechnicalRepresentation = technical_p;
            this.refresh(true);
        }
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        private List<EStructuralFeature> getAllFeatures(IMatch match_p) {
            Role drivingRole = FeaturesViewer.this.getInput().getContext().getDrivingRole();
            EObject element = match_p.get(drivingRole);
            if (element == null) {
                element = match_p.get(drivingRole.opposite());
            }
            assert (element != null);
            EClass eClass = element.eClass();
            ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
            result.addAll((Collection<EStructuralFeature>)eClass.getEAllAttributes());
            for (EReference ref : eClass.getEAllReferences()) {
                if (!this.qualifies(ref) && match_p.getOrderDifference((EStructuralFeature)ref, drivingRole) == null) continue;
                result.add((EStructuralFeature)ref);
            }
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            List<EStructuralFeature> result;
            EMFDiffNode context = FeaturesViewer.this.getInput().getContext();
            Role drivingRole = context.getDrivingRole();
            IMatch match = ((FeaturesInput)inputElement_p).getMatch();
            if (FeaturesViewer.this.isDifferenceAgnostic()) {
                result = this.getAllFeatures(match);
            } else {
                result = new ArrayList<EStructuralFeature>(match.getAttributesWithDifferences());
                for (EReference ref : match.getReferencesWithDifferences()) {
                    if (context.isContainment((EStructuralFeature)ref) && match.getOrderDifference((EStructuralFeature)ref, drivingRole) == null) continue;
                    result.add((EStructuralFeature)ref);
                }
            }
            if (FeaturesViewer.this.getInput().getContext().getCategoryManager().representAsMove(match)) {
                result.add((EStructuralFeature)EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature());
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }

        private boolean qualifies(EReference reference_p) {
            return FeaturesViewer.this.isOwnershipFeature(reference_p) || !FeaturesViewer.this.getInput().getContext().isContainment((EStructuralFeature)reference_p) && !reference_p.isContainer() && reference_p.isChangeable() && !reference_p.isDerived();
        }
    }

    public static class FeaturesInput {
        private final EMFDiffNode _context;
        private final IMatch _match;

        public FeaturesInput(EMFDiffNode context_p, IMatch match_p) {
            this._context = context_p;
            this._match = match_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof FeaturesInput) {
                FeaturesInput peer = (FeaturesInput)object_p;
                result = this._context == peer.getContext() && this._match.equals((Object)peer.getMatch());
            }
            return result;
        }

        public EMFDiffNode getContext() {
            return this._context;
        }

        public IMatch getMatch() {
            return this._match;
        }

        public int hashCode() {
            return this._context.hashCode() + this._match.hashCode();
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        public LabelProvider() {
            super((ILabelProvider)DiffMergeLabelProvider.getInstance());
        }

        protected DifferenceKind getDifferenceKind(EStructuralFeature feature_p) {
            DifferenceKind result = DifferenceKind.NONE;
            if (FeaturesViewer.this.getInput() != null) {
                EMatch match = (EMatch)FeaturesViewer.this.getInput().getMatch();
                MatchAndFeatureImpl maf = new MatchAndFeatureImpl(match, feature_p);
                result = FeaturesViewer.this.getInput().getContext().getCategoryManager().getDifferenceKind(maf);
            }
            return result;
        }

        @Override
        public Font getFont(Object element_p) {
            Font result = FeaturesViewer.this.getControl().getFont();
            EStructuralFeature feature = (EStructuralFeature)element_p;
            DifferenceKind kind = this.getDifferenceKind(feature);
            if (!kind.isNeutral()) {
                result = UIUtil.getBold(result);
            }
            return result;
        }

        @Override
        public Color getForeground(Object element_p) {
            EStructuralFeature feature = (EStructuralFeature)element_p;
            DifferenceKind kind = this.getDifferenceKind(feature);
            EMFDiffMergeUIPlugin.DifferenceColorKind colorKind = EMFDiffMergeUIPlugin.getDefault().getDifferenceColorKind(kind);
            if (colorKind == EMFDiffMergeUIPlugin.DifferenceColorKind.NONE) {
                colorKind = EMFDiffMergeUIPlugin.DifferenceColorKind.DEFAULT;
            }
            Color result = FeaturesViewer.this.getInput().getContext().getDifferenceColor(colorKind);
            return result;
        }

        @Override
        public Image getImage(Object element_p) {
            Image result = null;
            result = FeaturesViewer.this.isOwnershipFeature(element_p) ? EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.TREE) : this.getDelegate().getImage(element_p);
            if (FeaturesViewer.this.getInput().getContext().usesCustomIcons() && element_p instanceof EStructuralFeature) {
                EStructuralFeature feature = (EStructuralFeature)element_p;
                DifferenceKind kind = this.getDifferenceKind(feature);
                result = FeaturesViewer.this.getResourceManager().adaptImage(result, kind);
            }
            return result;
        }

        @Override
        public String getText(Object element_p) {
            EStructuralFeature feature = (EStructuralFeature)element_p;
            String result = FeaturesViewer.this.isTechnical() ? this.getDelegate().getText((Object)feature) : UIUtil.getFormattedFeatureText(feature);
            if (FeaturesViewer.this.getInput().getContext().usesCustomLabels()) {
                DifferenceKind kind = this.getDifferenceKind(feature);
                String prefix = EMFDiffMergeUIPlugin.getDefault().getDifferencePrefix(kind);
                result = String.valueOf(prefix) + result;
            }
            return result;
        }
    }
}

