/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.EMFDiffMergeCoreConnectorPlugin;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHistoryURIConverter
extends ExtensibleURIConverterImpl {
    private final long _timestamp;
    private final String _basePath;

    public LocalHistoryURIConverter(long timestamp_p, String basePath_p) {
        this._timestamp = timestamp_p;
        this._basePath = basePath_p;
    }

    public InputStream createInputStream(URI uri_p, Map<?, ?> options_p) throws IOException {
        Object fullPath = uri_p.isPlatform() ? new Path(uri_p.toPlatformString(true)) : new Path(this._basePath).append(uri_p.toString());
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
        if (targetFile != null && targetFile.exists()) {
            try {
                IFileState[] states;
                if (targetFile.getLocalTimeStamp() <= this._timestamp) {
                    return targetFile.getContents();
                }
                IFileState[] iFileStateArray = states = targetFile.getHistory((IProgressMonitor)new NullProgressMonitor());
                int n = states.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileState iFileState = iFileStateArray[n2];
                    if (iFileState.getModificationTime() <= this._timestamp) {
                        return iFileState.getContents();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                EMFDiffMergeCoreConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeCoreConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        return super.createInputStream(uri_p, options_p);
    }

    public String getBasePath() {
        return this._basePath;
    }

    public long getTimestamp() {
        return this._timestamp;
    }
}

