/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewContentProvider;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewLabelProvider;
import org.eclipse.dirigible.ide.db.viewer.views.IDbConnectionFactory;
import org.eclipse.dirigible.ide.db.viewer.views.Messages;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.dirigible.ide.db.viewer.views.actions.DeleteTableAction;
import org.eclipse.dirigible.ide.db.viewer.views.actions.ExportDataAction;
import org.eclipse.dirigible.ide.db.viewer.views.actions.RefreshViewAction;
import org.eclipse.dirigible.ide.db.viewer.views.actions.ShowTableDefinitionAction;
import org.eclipse.dirigible.ide.db.viewer.views.actions.ViewTableContentAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class DatabaseViewer
extends ViewPart
implements IDbConnectionFactory {
    private static final String DATABASE_VIEW = Messages.DatabaseViewer_DATABASE_VIEW;
    public static final String ID = "org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer";
    protected TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    protected Action viewTableContentAction;
    private Action deleteAction;
    private Action exportDataAction;
    private Action doubleClickAction;
    private boolean isOperator = CommonParameters.isUserInRole((String)"Operator");
    private ShowTableDefinitionAction showTableDefinitionAction;
    protected RefreshViewAction refreshViewAction;

    public void createPartControl(Composite parent) {
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.viewer = tree.getViewer();
        new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider(this.initContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DatabaseViewLabelProvider(this));
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    protected IContentProvider initContentProvider() {
        return new DatabaseViewContentProvider(this);
    }

    protected IFilter getSchemaFilter(Connection connection) throws SQLException {
        return null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = -4330735691305481160L;

            public void menuAboutToShow(IMenuManager manager) {
                DatabaseViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showTableDefinitionAction);
        manager.add((IAction)this.viewTableContentAction);
        manager.add((IAction)this.exportDataAction);
        manager.add((IContributionItem)new Separator());
        if (this.isOperator) {
            manager.add((IAction)this.deleteAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshViewAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!TreeParent.class.isInstance(obj) && TreeObject.class.isInstance(obj)) {
            manager.add((IAction)this.showTableDefinitionAction);
            manager.add((IAction)this.viewTableContentAction);
            manager.add((IAction)this.exportDataAction);
            manager.add((IContributionItem)new Separator());
            if (this.isOperator) {
                manager.add((IAction)this.deleteAction);
            }
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.refreshViewAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.showTableDefinitionAction);
        manager.add((IAction)this.viewTableContentAction);
        manager.add((IAction)this.exportDataAction);
        manager.add((IContributionItem)new Separator());
        if (this.isOperator) {
            manager.add((IAction)this.deleteAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshViewAction);
    }

    private void makeActions() {
        this.createRefreshAction();
        this.createExportDataAction();
        this.createViewTableContentAction();
        this.createShowTableDefinitionAction();
        if (this.isOperator) {
            this.deleteAction = new DeleteTableAction(this.viewer);
        }
        this.doubleClickAction = new ShowTableDefinitionAction(this.viewer);
    }

    protected void createRefreshAction() {
        this.refreshViewAction = new RefreshViewAction(this.viewer);
    }

    protected void createViewTableContentAction() {
        this.viewTableContentAction = new ViewTableContentAction(this.viewer, "org.eclipse.dirigible.ide.db.viewer.views.SQLConsole");
    }

    protected void createShowTableDefinitionAction() {
        this.showTableDefinitionAction = new ShowTableDefinitionAction(this.viewer);
    }

    protected void createExportDataAction() {
        this.exportDataAction = new ExportDataAction(this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DatabaseViewer.this.doubleClickAction.run();
            }
        });
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)DATABASE_VIEW, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public Connection getDatabaseConnection() throws SQLException {
        return DatabaseViewer.getConnectionFromSelectedDatasource();
    }

    public static Connection getConnectionFromSelectedDatasource() throws SQLException {
        DataSource dataSource = DataSourceFacade.getInstance().getDataSource();
        Connection connection = dataSource.getConnection();
        return connection;
    }

    public boolean showSchemes() {
        return false;
    }

    class NameSorter
    extends ViewerSorter {
        private static final long serialVersionUID = -7067479902071396325L;

        NameSorter() {
        }
    }
}

