/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class SAPDBSpecifier
implements IDialectSpecifier {
    private static final String LIMIT_D_D = "LIMIT %d, %d";
    private static final String SAPDB_TIMESTAMP = "TIMESTAMP";
    private static final String SAPDB_FLOAT = "DOUBLE";
    private static final String SAPDB_BLOB = "BLOB";
    private static final String SAPDB_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", SAPDB_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", SAPDB_TIMESTAMP);
        sql = sql.replace("$BLOB$", SAPDB_BLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return SAPDB_FLOAT;
        }
        return commonType;
    }

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_D, offset, limit);
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return "";
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public String getAlterAddClose() {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        Blob data = resultSet.getBlob(columnName);
        return data.getBinaryStream();
    }
}

