/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class SybaseDBSpecifier
implements IDialectSpecifier {
    private static final String SYBASE_TIMESTAMP = "DATETIME";
    private static final String SYBASE_FLOAT = "REAL";
    private static final String SYBASE_BLOB = "IMAGE";
    private static final String SYBASE_CURRENT_TIMESTAMP = "GETDATE()";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", SYBASE_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", SYBASE_TIMESTAMP);
        sql = sql.replace("$BLOB$", SYBASE_BLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("TIMESTAMP".equals(commonType)) {
            return SYBASE_TIMESTAMP;
        }
        if ("FLOAT".equals(commonType)) {
            return SYBASE_FLOAT;
        }
        if ("BLOB".equals(commonType)) {
            return SYBASE_BLOB;
        }
        return commonType;
    }

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return "";
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return String.format("TOP %d ROWS START AT %d", limit, offset);
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public String getAlterAddOpen() {
        return "";
    }

    @Override
    public String getAlterAddClose() {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        return new ByteArrayInputStream(resultSet.getBytes(columnName));
    }
}

