/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractMarkupDocumentBuilder;

public class ConfluenceDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final Pattern PATTERN_MULTIPLE_NEWLINES = Pattern.compile("(\r\n|\r|\n){2,}");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();

    public ConfluenceDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("nbsp", " ");
        this.entityToLiteral.put("#160", " ");
        this.entityToLiteral.put("quot", "\"");
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.entityToLiteral.put("copy", "(c)");
        this.entityToLiteral.put("reg", "(r)");
        this.entityToLiteral.put("#8482", "(t)");
        this.entityToLiteral.put("euro", "\u20ac");
        this.entityToLiteral.put("#36", "$");
        this.entityToLiteral.put("#37", "%");
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case NUMERIC_LIST: 
            case BULLETED_LIST: 
            case DEFINITION_LIST: {
                DocumentBuilder.BlockType currentBlockType;
                if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_TERM)) {
                    return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, 1, 1);
                }
                return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, 2, 1);
            }
            case CODE: {
                return new ContentBlock(type, "{code}", "{code}\n\n", false, false, 2, 2);
            }
            case LIST_ITEM: 
            case DEFINITION_TERM: 
            case DEFINITION_ITEM: {
                char prefixChar = this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST ? (char)'#' : '*';
                return new ContentBlock(type, String.valueOf(this.computePrefix(prefixChar, this.computeListLevel())) + " ", "", false, true, 1, 1);
            }
            case DIV: {
                if (this.currentBlock == null) {
                    return new ContentBlock(type, "", "", false, false, 2, 2);
                }
                return new ContentBlock(type, "", "", true, false, 0, 0);
            }
            case FOOTNOTE: {
                return new ContentBlock(type, "fn1. ", "", false, false, 2, 2);
            }
            case TIP: 
            case WARNING: 
            case INFORMATION: 
            case NOTE: 
            case PANEL: {
                attributes.appendCssClass(type.name().toLowerCase());
            }
            case PARAGRAPH: {
                String attributesMarkup = this.computeAttributes(attributes);
                return new ContentBlock(type, attributesMarkup, "", false, false, 2, 2);
            }
            case PREFORMATTED: {
                return new ContentBlock(type, "{noformat}", "{noformat}", false, false, 2, 2);
            }
            case QUOTE: {
                return new ContentBlock(type, "{quote}", "{quote}", false, false, 2, 2);
            }
            case TABLE: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new TableCellBlock(type);
            }
            case TABLE_ROW: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "|\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", false, false, 0, 0);
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        ContentBlock block;
        String spanAttributes = this.computeAttributes(attributes);
        switch (type) {
            case BOLD: {
                block = new ContentBlock("*" + spanAttributes, "*", true, false, 0, 0);
                break;
            }
            case CITATION: {
                block = new ContentBlock("??" + spanAttributes, "??", true, false, 0, 0);
                break;
            }
            case DELETED: {
                block = new ContentBlock("-" + spanAttributes, "-", true, false, 0, 0);
                break;
            }
            case EMPHASIS: 
            case ITALIC: {
                block = new ContentBlock("_" + spanAttributes, "_", true, false, 0, 0);
                break;
            }
            case INSERTED: {
                block = new ContentBlock("+" + spanAttributes, "+", true, false, 0, 0);
                break;
            }
            case CODE: {
                block = new ContentBlock("@" + spanAttributes, "@", true, false, 0, 0);
                break;
            }
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    block = new LinkBlock((LinkAttributes)attributes);
                    break;
                }
                block = new ContentBlock("%" + spanAttributes, "%", true, true, 0, 0);
                break;
            }
            case MONOSPACE: {
                block = new ContentBlock("{{", "}}", true, false, 0, 0);
                break;
            }
            case STRONG: {
                block = new ContentBlock("*" + spanAttributes, "*", true, false, 0, 0);
                break;
            }
            case SUPERSCRIPT: {
                block = new ContentBlock("^" + spanAttributes, "^", true, false, 0, 0);
                break;
            }
            case SUBSCRIPT: {
                block = new ContentBlock("~" + spanAttributes, "~", true, false, 0, 0);
                break;
            }
            case UNDERLINED: {
                block = new ContentBlock("+", "+", true, false, 0, 0);
                break;
            }
            default: {
                Matcher colorMatcher;
                block = null;
                if (attributes.getCssStyle() != null && (colorMatcher = Pattern.compile("color:\\s*([^; \t]+)").matcher(attributes.getCssStyle())).find()) {
                    String color = colorMatcher.group(1);
                    if (color.equalsIgnoreCase("black") || color.equals("#010101")) {
                        color = null;
                    }
                    if (color != null) {
                        block = new ContentBlock("{color:" + color + "}", "{color}", true, false, 0, 0);
                    }
                }
                if (block != null) break;
                block = new ContentBlock("", "", false, false, 0, 0);
            }
        }
        return block;
    }

    private String computeAttributes(Attributes attributes) {
        String attributeMarkup = "";
        return attributeMarkup;
    }

    protected ContentBlock computeHeading(int level, Attributes attributes) {
        return new ContentBlock("h" + level + ". ", "", false, false, 2, 2);
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            int x = 0;
            while (x < text.length()) {
                char c = text.charAt(x);
                switch (c) {
                    case '\u00a0': {
                        this.currentBlock.write(32);
                        break;
                    }
                    case '\u00a9': {
                        this.currentBlock.write("(c)");
                        break;
                    }
                    case '\u00ae': {
                        this.currentBlock.write("(r)");
                        break;
                    }
                    default: {
                        this.currentBlock.write((int)c);
                    }
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        String literal = this.entityToLiteral.get(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write(literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        if (url != null) {
            this.assertOpenBlock();
            try {
                this.currentBlock.write(33);
                this.writeAttributes(attributes);
                this.currentBlock.write(url);
                this.currentBlock.write(33);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttributes = new LinkAttributes();
        linkAttributes.setTitle(attributes.getTitle());
        linkAttributes.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttributes);
        this.characters(text);
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(33);
            this.writeAttributes(imageAttributes);
            this.currentBlock.write(imageUrl);
            this.currentBlock.write(33);
            this.currentBlock.write(58);
            this.currentBlock.write(href);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
            this.currentBlock.write(40);
            this.currentBlock.write(definition);
            this.currentBlock.write(41);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof ConfluenceBlock) {
                ((ConfluenceBlock)this.currentBlock).writeLineBreak();
            } else {
                this.currentBlock.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeAttributes(Attributes attributes) {
        try {
            this.currentBlock.write(this.computeAttributes(attributes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private static interface ConfluenceBlock {
        public void writeLineBreak() throws IOException;
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements ConfluenceBlock {
        private final String prefix;
        private final String suffix;
        private final boolean requireAdjacentSeparator;
        private final boolean emitWhenEmpty;
        private int consecutiveLineBreakCount;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, boolean requireAdjacentSeparator, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines) {
            super((AbstractMarkupDocumentBuilder)ConfluenceDocumentBuilder.this, blockType, leadingNewlines, trailingNewlines);
            this.consecutiveLineBreakCount = 0;
            this.prefix = prefix;
            this.suffix = suffix;
            this.requireAdjacentSeparator = requireAdjacentSeparator;
            this.emitWhenEmpty = emitWhenEmpty;
        }

        ContentBlock(String prefix, String suffix, boolean requireAdjacentWhitespace, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines) {
            this(null, prefix, suffix, requireAdjacentWhitespace, emitWhenEmpty, leadingNewlines, trailingNewlines);
        }

        public void write(int c) throws IOException {
            this.consecutiveLineBreakCount = 0;
            if (this.getBlockType() != DocumentBuilder.BlockType.CODE && this.getBlockType() != DocumentBuilder.BlockType.PREFORMATTED) {
                c = ConfluenceDocumentBuilder.this.normalizeWhitespace(c);
            }
            ConfluenceDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            this.consecutiveLineBreakCount = 0;
            if (this.getBlockType() != DocumentBuilder.BlockType.CODE && this.getBlockType() != DocumentBuilder.BlockType.PREFORMATTED) {
                s = ConfluenceDocumentBuilder.this.normalizeWhitespace(s);
            }
            ConfluenceDocumentBuilder.this.emitContent(s);
        }

        @Override
        public void writeLineBreak() throws IOException {
            ++this.consecutiveLineBreakCount;
            if (this.consecutiveLineBreakCount == 1 || this.getBlockType() == DocumentBuilder.BlockType.CODE || this.getBlockType() == DocumentBuilder.BlockType.PREFORMATTED) {
                ConfluenceDocumentBuilder.this.emitContent(10);
            } else {
                ConfluenceDocumentBuilder.this.emitContent("\\\\");
            }
        }

        public void open() throws IOException {
            super.open();
            ConfluenceDocumentBuilder.this.pushWriter(new StringWriter());
            if (this.requireAdjacentSeparator) {
                ConfluenceDocumentBuilder.this.clearRequireAdjacentSeparator();
            }
        }

        public void close() throws IOException {
            Writer thisContent = ConfluenceDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            if (content.length() > 0 || this.emitWhenEmpty) {
                boolean extendedBlock = this.isExtended(content);
                if (this.requireAdjacentSeparator) {
                    ConfluenceDocumentBuilder.this.requireAdjacentSeparator();
                }
                this.emitContent(content, extendedBlock);
                if (this.requireAdjacentSeparator) {
                    ConfluenceDocumentBuilder.this.requireAdjacentSeparator();
                }
            }
            super.close();
            this.consecutiveLineBreakCount = 0;
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            String prefix = extended ? this.prefix.replace(".", "..") : this.prefix;
            String suffix = extended ? String.valueOf(this.suffix) + "\n" : this.suffix;
            ConfluenceDocumentBuilder.this.emitContent(prefix);
            ConfluenceDocumentBuilder.this.emitContent(content);
            ConfluenceDocumentBuilder.this.emitContent(suffix);
        }

        private boolean isExtended(String content) {
            if (this.getBlockType() != null) {
                switch (this.getBlockType()) {
                    case QUOTE: 
                    case CODE: 
                    case PREFORMATTED: {
                        return PATTERN_MULTIPLE_NEWLINES.matcher(content).find();
                    }
                }
            }
            return false;
        }
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "", false, false, 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        private LinkBlock(LinkAttributes attributes) {
            super(null, "", "", true, true, 0, 0);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content, boolean extended) throws IOException {
            ConfluenceDocumentBuilder.this.emitContent(91);
            if (!Strings.isNullOrEmpty((String)content)) {
                ConfluenceDocumentBuilder.this.emitContent(content);
                ConfluenceDocumentBuilder.this.emitContent(" | ");
            }
            if (this.attributes.getHref() != null) {
                ConfluenceDocumentBuilder.this.emitContent(this.attributes.getHref());
            }
            if (!Strings.isNullOrEmpty((String)this.attributes.getTitle())) {
                ConfluenceDocumentBuilder.this.emitContent(" | ");
                ConfluenceDocumentBuilder.this.emitContent(this.attributes.getTitle());
            }
            ConfluenceDocumentBuilder.this.emitContent(93);
        }
    }

    private class TableCellBlock
    extends ContentBlock {
        public TableCellBlock(DocumentBuilder.BlockType blockType) {
            super(blockType, blockType == DocumentBuilder.BlockType.TABLE_CELL_NORMAL ? "|" : "||", "", false, true, 0, 0);
        }

        @Override
        protected void emitContent(String content, boolean extended) throws IOException {
            if (content.length() == 0) {
                content = " ";
            }
            content = content.replaceAll("(\\r|\\n)+", " ");
            super.emitContent(content, extended);
        }
    }
}

