/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSaxHtmlParser {
    private static final Pattern HEADING_PATTERN = Pattern.compile("h([1-6])");
    private static Set<String> blockElements;
    private static Set<String> whitespaceCollapsingElements;
    private static Set<String> noCharacterContentElements;
    private static final Map<String, DocumentBuilder.SpanType> elementNameToSpanType;
    private static final Map<String, DocumentBuilder.BlockType> elementNameToBlockType;

    static {
        ImmutableSet.Builder blockElementsBuilder = ImmutableSet.builder();
        blockElementsBuilder.add((Object)"div");
        blockElementsBuilder.add((Object)"dl");
        blockElementsBuilder.add((Object)"form");
        blockElementsBuilder.add((Object)"h1");
        blockElementsBuilder.add((Object)"h2");
        blockElementsBuilder.add((Object)"h3");
        blockElementsBuilder.add((Object)"h4");
        blockElementsBuilder.add((Object)"h5");
        blockElementsBuilder.add((Object)"h6");
        blockElementsBuilder.add((Object)"ol");
        blockElementsBuilder.add((Object)"p");
        blockElementsBuilder.add((Object)"pre");
        blockElementsBuilder.add((Object)"table");
        blockElementsBuilder.add((Object)"textarea");
        blockElementsBuilder.add((Object)"td");
        blockElementsBuilder.add((Object)"tr");
        blockElementsBuilder.add((Object)"ul");
        blockElementsBuilder.add((Object)"tbody");
        blockElementsBuilder.add((Object)"thead");
        blockElementsBuilder.add((Object)"tfoot");
        blockElementsBuilder.add((Object)"li");
        blockElementsBuilder.add((Object)"dd");
        blockElementsBuilder.add((Object)"dt");
        blockElementsBuilder.add((Object)"blockquote");
        blockElements = blockElementsBuilder.build();
        ImmutableSet.Builder whitespaceCollapsingElementsBuilder = ImmutableSet.builder();
        whitespaceCollapsingElementsBuilder.add((Object)"br");
        whitespaceCollapsingElementsBuilder.add((Object)"hr");
        whitespaceCollapsingElements = whitespaceCollapsingElementsBuilder.build();
        ImmutableSet.Builder noCharacterContentElementsBuilder = ImmutableSet.builder();
        noCharacterContentElementsBuilder.add((Object)"ul");
        noCharacterContentElementsBuilder.add((Object)"ol");
        noCharacterContentElementsBuilder.add((Object)"table");
        noCharacterContentElementsBuilder.add((Object)"tbody");
        noCharacterContentElementsBuilder.add((Object)"thead");
        noCharacterContentElementsBuilder.add((Object)"tr");
        noCharacterContentElements = noCharacterContentElementsBuilder.build();
        elementNameToSpanType = new HashMap<String, DocumentBuilder.SpanType>();
        elementNameToSpanType.put("a", DocumentBuilder.SpanType.LINK);
        elementNameToSpanType.put("b", DocumentBuilder.SpanType.BOLD);
        elementNameToSpanType.put("cite", DocumentBuilder.SpanType.CITATION);
        elementNameToSpanType.put("i", DocumentBuilder.SpanType.ITALIC);
        elementNameToSpanType.put("em", DocumentBuilder.SpanType.EMPHASIS);
        elementNameToSpanType.put("strong", DocumentBuilder.SpanType.STRONG);
        elementNameToSpanType.put("del", DocumentBuilder.SpanType.DELETED);
        elementNameToSpanType.put("strike", DocumentBuilder.SpanType.DELETED);
        elementNameToSpanType.put("ins", DocumentBuilder.SpanType.INSERTED);
        elementNameToSpanType.put("q", DocumentBuilder.SpanType.QUOTE);
        elementNameToSpanType.put("u", DocumentBuilder.SpanType.UNDERLINED);
        elementNameToSpanType.put("sup", DocumentBuilder.SpanType.SUPERSCRIPT);
        elementNameToSpanType.put("sub", DocumentBuilder.SpanType.SUBSCRIPT);
        elementNameToSpanType.put("span", DocumentBuilder.SpanType.SPAN);
        elementNameToSpanType.put("font", DocumentBuilder.SpanType.SPAN);
        elementNameToSpanType.put("code", DocumentBuilder.SpanType.CODE);
        elementNameToSpanType.put("tt", DocumentBuilder.SpanType.MONOSPACE);
        elementNameToBlockType = new HashMap<String, DocumentBuilder.BlockType>();
        elementNameToBlockType.put("ul", DocumentBuilder.BlockType.BULLETED_LIST);
        elementNameToBlockType.put("code", DocumentBuilder.BlockType.CODE);
        elementNameToBlockType.put("div", DocumentBuilder.BlockType.DIV);
        elementNameToBlockType.put("footnote", DocumentBuilder.BlockType.FOOTNOTE);
        elementNameToBlockType.put("li", DocumentBuilder.BlockType.LIST_ITEM);
        elementNameToBlockType.put("ol", DocumentBuilder.BlockType.NUMERIC_LIST);
        elementNameToBlockType.put("dl", DocumentBuilder.BlockType.DEFINITION_LIST);
        elementNameToBlockType.put("dt", DocumentBuilder.BlockType.DEFINITION_TERM);
        elementNameToBlockType.put("dd", DocumentBuilder.BlockType.DEFINITION_ITEM);
        elementNameToBlockType.put("p", DocumentBuilder.BlockType.PARAGRAPH);
        elementNameToBlockType.put("pre", DocumentBuilder.BlockType.PREFORMATTED);
        elementNameToBlockType.put("blockquote", DocumentBuilder.BlockType.QUOTE);
        elementNameToBlockType.put("table", DocumentBuilder.BlockType.TABLE);
        elementNameToBlockType.put("th", DocumentBuilder.BlockType.TABLE_CELL_HEADER);
        elementNameToBlockType.put("td", DocumentBuilder.BlockType.TABLE_CELL_NORMAL);
        elementNameToBlockType.put("tr", DocumentBuilder.BlockType.TABLE_ROW);
    }

    private Attributes computeAttributes(DocumentBuilder.SpanType spanType, org.xml.sax.Attributes atts) {
        String href;
        Attributes attributes = spanType == DocumentBuilder.SpanType.LINK ? new LinkAttributes() : new Attributes();
        this.populateCommonAttributes(attributes, atts);
        if (spanType == DocumentBuilder.SpanType.LINK && (href = this.getValue("href", atts)) != null) {
            ((LinkAttributes)attributes).setHref(href);
        }
        return attributes;
    }

    private String getValue(String name, org.xml.sax.Attributes atts) {
        int x = 0;
        while (x < atts.getLength()) {
            String localName = atts.getLocalName(x);
            if (localName.equals(name)) {
                return atts.getValue(x);
            }
            ++x;
        }
        return null;
    }

    private Attributes computeAttributes(org.xml.sax.Attributes atts) {
        Attributes attributes = new Attributes();
        this.populateCommonAttributes(attributes, atts);
        return attributes;
    }

    private String getAttribute(org.xml.sax.Attributes atts, String name) {
        int x = 0;
        while (x < atts.getLength()) {
            String localName = atts.getLocalName(x);
            if (name.equals(localName)) {
                return atts.getValue(x);
            }
            ++x;
        }
        return null;
    }

    private void populateCommonAttributes(Attributes attributes, org.xml.sax.Attributes atts) {
        int x = 0;
        while (x < atts.getLength()) {
            String localName = atts.getLocalName(x);
            if (localName.equals("id") || localName.equals("name")) {
                attributes.setId(atts.getValue(x));
            } else if (localName.equals("style")) {
                attributes.setCssStyle(atts.getValue(x));
            } else if (localName.equals("class")) {
                attributes.setCssClass(atts.getValue(x));
            } else if (localName.equals("title")) {
                attributes.setTitle(atts.getValue(x));
            } else if (localName.equals("color")) {
                attributes.appendCssStyle("color: " + atts.getValue(x) + ";");
            }
            ++x;
        }
    }

    private static String trimRight(String text) {
        int len = text.length();
        while (len > 0 && text.charAt(len - 1) <= ' ') {
            --len;
        }
        return len < text.length() ? text.substring(0, len) : text;
    }

    private static String trimLeft(String text) {
        int len = text.length();
        int st = 0;
        while (st < len && text.charAt(st) <= ' ') {
            ++st;
        }
        return st > 0 ? text.substring(st, len) : text;
    }

    protected abstract void parse(InputSource var1, DocumentBuilder var2, ContentHandler var3) throws IOException, SAXException;

    public void parse(InputSource input, DocumentBuilder builder, boolean asDocument) throws IOException, SAXException {
        this.parse(input, builder, this.createContentHandler(builder, asDocument));
    }

    protected ContentHandler createContentHandler(DocumentBuilder builder) {
        return this.createContentHandler(builder, true);
    }

    protected ContentHandler createContentHandler(DocumentBuilder builder, boolean asDocument) {
        return new DocumentBuilderAdapter(builder, asDocument);
    }

    private class DocumentBuilderAdapter
    implements ContentHandler {
        private final Stack<ElementHandler> handlers = new Stack();
        private ElementState elementState;
        private final DocumentBuilder builder;
        private boolean processingContent;
        private final StringBuilder elementText = new StringBuilder();
        private final boolean asDocument;

        public DocumentBuilderAdapter(DocumentBuilder builder, boolean asDocument) {
            this.builder = builder;
            this.asDocument = asDocument;
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
            String lowerCaseName = localName.toLowerCase();
            if (this.processingContent) {
                this.emitText(this.elementState, lowerCaseName, false);
            }
            this.elementState = new ElementState(this.elementState, lowerCaseName);
            if (!this.processingContent && lowerCaseName.equals("body")) {
                this.processingContent = true;
            }
            if (this.elementState.parent != null) {
                ++this.elementState.parent.childCount;
            }
            ElementHandler handler = this.computeElementHandler(lowerCaseName);
            this.handlers.push(handler);
            handler.start(atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.emitText(this.elementState, null, true);
            String lowerCaseName = localName.toLowerCase();
            this.elementState = this.elementState.parent;
            if (this.processingContent && lowerCaseName.equals("body")) {
                this.processingContent = false;
            }
            if (!this.processingContent) {
                return;
            }
            ElementHandler handler = this.handlers.pop();
            handler.end();
        }

        private void emitText(ElementState elementState, String nextElementName, boolean elementClosing) {
            String text = this.elementText.toString();
            if (!elementState.canHaveCharacterContent) {
                text = text.trim();
            } else if (!elementState.preserveWhitespace) {
                if (elementClosing) {
                    if (elementState.childCount == 0) {
                        if (elementState.blockElement) {
                            text = text.trim();
                        }
                    } else if (elementState.blockElement) {
                        text = AbstractSaxHtmlParser.trimRight(text);
                    }
                } else {
                    String originalText = text;
                    if (elementState.blockElement && elementState.childCount == 0 && (text = AbstractSaxHtmlParser.trimLeft(text)).length() == 0 && originalText.length() > 0) {
                        text = originalText.substring(0, 1);
                    }
                    if (nextElementName != null && blockElements.contains(nextElementName)) {
                        text = AbstractSaxHtmlParser.trimRight(text);
                    }
                }
            }
            this.elementText.delete(0, this.elementText.length());
            if (text.length() > 0) {
                this.handlers.peek().characters(text);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.processingContent) {
                if (this.elementState.noWhitespaceTextContainer && (this.elementState.lastChild == null || this.elementState.lastChild.blockElement) || this.elementState.blockElement && !this.elementState.preserveWhitespace && this.elementState.textChildCount == 0 && this.elementState.childCount == 0 || this.elementState.lastChild != null && this.elementState.lastChild.collapsesAdjacentWhitespace) {
                    int skip = 0;
                    while (skip < length && Character.isWhitespace(ch[start + skip])) {
                        ++skip;
                    }
                    start += skip;
                    length -= skip;
                }
                this.elementState.lastChild = null;
                if (length != 0) {
                    ++this.elementState.textChildCount;
                    this.append(this.elementState, ch, start, length);
                }
            }
        }

        private void append(ElementState elementState, char[] ch, int start, int length) {
            if (!elementState.preserveWhitespace) {
                int previousWhitespaceIndex = Integer.MIN_VALUE;
                int x = 0;
                while (x < length) {
                    int index = start + x;
                    char c = ch[index];
                    if (Character.isWhitespace(c)) {
                        if (previousWhitespaceIndex == index - 1) {
                            previousWhitespaceIndex = index;
                        } else {
                            previousWhitespaceIndex = index;
                            this.elementText.append(c == '\t' ? c : (char)' ');
                        }
                    } else {
                        this.elementText.append(c);
                    }
                    ++x;
                }
            } else {
                this.elementText.append(ch, start, length);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.asDocument) {
                this.builder.beginDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.asDocument) {
                this.builder.endDocument();
            } else {
                this.builder.flush();
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.processingContent && this.elementState.preserveWhitespace) {
                this.characters(ch, start, length);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        private ElementHandler computeElementHandler(String elementName) {
            ElementHandler outerHandler;
            DocumentBuilder.BlockType blockType = (DocumentBuilder.BlockType)((Object)elementNameToBlockType.get(elementName));
            if (blockType == null) {
                DocumentBuilder.SpanType spanType = (DocumentBuilder.SpanType)((Object)elementNameToSpanType.get(elementName));
                if (spanType != null) {
                    if (elementName.equals("font")) {
                        return new FontElementHandler(spanType);
                    }
                    return new SpanElementHandler(spanType);
                }
                if (elementName.equals("img")) {
                    return new ImageElementHandler();
                }
                if (elementName.equals("br")) {
                    return new LineBreakHandler();
                }
                if (elementName.equals("hr")) {
                    return new HorizontalRuleHandler();
                }
                Matcher headingMatcher = HEADING_PATTERN.matcher(elementName);
                if (headingMatcher.matches()) {
                    return new HeadingElementHandler(Integer.parseInt(headingMatcher.group(1)));
                }
                return new ContentElementHandler();
            }
            if (blockType == DocumentBuilder.BlockType.CODE && !this.handlers.isEmpty() && !((outerHandler = this.handlers.peek()) instanceof PreformattedBlockElementHandler)) {
                return new SpanElementHandler(DocumentBuilder.SpanType.CODE);
            }
            if (blockType == DocumentBuilder.BlockType.PREFORMATTED) {
                return new PreformattedBlockElementHandler();
            }
            if (blockType == DocumentBuilder.BlockType.NUMERIC_LIST) {
                return new NumericListElementHandler();
            }
            return new BlockElementHandler(blockType);
        }

        private class BlockElementHandler
        extends ElementHandler {
            private final DocumentBuilder.BlockType blockType;

            BlockElementHandler(DocumentBuilder.BlockType blockType) {
                this.blockType = blockType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                DocumentBuilderAdapter.this.builder.beginBlock(this.blockType, AbstractSaxHtmlParser.this.computeAttributes(atts));
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.endBlock();
            }

            @Override
            public void characters(String s) {
                DocumentBuilderAdapter.this.builder.characters(s);
            }
        }

        private class ContentElementHandler
        extends ElementHandler {
            private ContentElementHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
            }
        }

        private abstract class ElementHandler {
            private ElementHandler() {
            }

            abstract void start(org.xml.sax.Attributes var1);

            abstract void end();

            void characters(String s) {
                DocumentBuilderAdapter.this.builder.characters(s);
            }
        }

        private class FontElementHandler
        extends ElementHandler {
            private final DocumentBuilder.SpanType spanType;
            private boolean noop;

            private FontElementHandler(DocumentBuilder.SpanType spanType) {
                this.spanType = spanType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = this.computeFontAttributes(atts);
                if (this.spanType == DocumentBuilder.SpanType.SPAN && attributes.getCssClass() == null && attributes.getCssStyle() == null && attributes.getId() == null) {
                    this.noop = true;
                } else {
                    DocumentBuilderAdapter.this.builder.beginSpan(this.spanType, attributes);
                }
            }

            @Override
            public void end() {
                if (!this.noop) {
                    DocumentBuilderAdapter.this.builder.endSpan();
                }
            }

            private Attributes computeFontAttributes(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(this.spanType, atts);
                int x = 0;
                while (x < atts.getLength()) {
                    String localName = atts.getLocalName(x);
                    if (localName.equals("face")) {
                        attributes.appendCssStyle("font-family: " + atts.getValue(x) + ";");
                    } else if (localName.equals("size")) {
                        attributes.appendCssStyle("font-size: " + atts.getValue(x) + ";");
                    }
                    ++x;
                }
                return attributes;
            }
        }

        private class HeadingElementHandler
        extends ElementHandler {
            int level;

            private HeadingElementHandler(int level) {
                this.level = level;
            }

            @Override
            void start(org.xml.sax.Attributes atts) {
                DocumentBuilderAdapter.this.builder.beginHeading(this.level, AbstractSaxHtmlParser.this.computeAttributes(atts));
            }

            @Override
            void end() {
                DocumentBuilderAdapter.this.builder.endHeading();
            }
        }

        private class HorizontalRuleHandler
        extends ElementHandler {
            private HorizontalRuleHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.horizontalRule();
            }
        }

        private class ImageElementHandler
        extends ElementHandler {
            private ImageElementHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(DocumentBuilder.SpanType.SPAN, atts);
                DocumentBuilderAdapter.this.builder.image(attributes, AbstractSaxHtmlParser.this.getValue("src", atts));
            }

            @Override
            public void end() {
            }
        }

        private class LineBreakHandler
        extends ElementHandler {
            private LineBreakHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.lineBreak();
            }
        }

        private class NumericListElementHandler
        extends BlockElementHandler {
            NumericListElementHandler() {
                super(DocumentBuilder.BlockType.NUMERIC_LIST);
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                ListAttributes listAttributes = new ListAttributes();
                AbstractSaxHtmlParser.this.populateCommonAttributes(listAttributes, atts);
                listAttributes.setStart(AbstractSaxHtmlParser.this.getAttribute(atts, "start"));
                DocumentBuilderAdapter.this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, listAttributes);
            }
        }

        private class PreformattedBlockElementHandler
        extends ElementHandler {
            private org.xml.sax.Attributes atts;

            private PreformattedBlockElementHandler() {
            }

            @Override
            void start(org.xml.sax.Attributes atts) {
                this.atts = new AttributesImpl(atts);
            }

            @Override
            void end() {
                if (this.atts == null) {
                    DocumentBuilderAdapter.this.builder.endBlock();
                }
            }

            @Override
            void characters(String s) {
                if (this.atts != null) {
                    DocumentBuilderAdapter.this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, AbstractSaxHtmlParser.this.computeAttributes(this.atts));
                    this.atts = null;
                }
                super.characters(s);
            }
        }

        private class SpanElementHandler
        extends ElementHandler {
            private final DocumentBuilder.SpanType spanType;
            private boolean noop;

            private SpanElementHandler(DocumentBuilder.SpanType spanType) {
                this.spanType = spanType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(this.spanType, atts);
                if (this.spanType == DocumentBuilder.SpanType.SPAN && attributes.getCssClass() == null && attributes.getCssStyle() == null && attributes.getId() == null) {
                    this.noop = true;
                } else {
                    DocumentBuilderAdapter.this.builder.beginSpan(this.spanType, attributes);
                }
            }

            @Override
            public void end() {
                if (!this.noop) {
                    DocumentBuilderAdapter.this.builder.endSpan();
                }
            }
        }
    }

    private static final class ElementState {
        final String elementName;
        final ElementState parent;
        final boolean preserveWhitespace;
        final boolean blockElement;
        final boolean noWhitespaceTextContainer;
        final boolean collapsesAdjacentWhitespace;
        final boolean canHaveCharacterContent;
        int childCount = 0;
        int textChildCount = 0;
        ElementState lastChild;

        private ElementState(ElementState parent, String elementName) {
            this.parent = parent;
            this.elementName = elementName;
            this.blockElement = blockElements.contains(elementName);
            this.collapsesAdjacentWhitespace = this.blockElement || whitespaceCollapsingElements.contains(elementName);
            this.noWhitespaceTextContainer = "body".equals(elementName);
            this.preserveWhitespace = parent != null && parent.preserveWhitespace || "pre".equals(elementName);
            boolean bl = this.canHaveCharacterContent = !noCharacterContentElements.contains(elementName);
            if (parent != null) {
                parent.lastChild = this;
            }
        }
    }
}

