/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.dirigible.ide.common.ExtensionPointUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypeDescriptor;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypeException;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypePageLabelProvider;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class TemplateTypeWizardPage
extends WizardPage {
    private static final String EXTENSION_POINT_0_COULD_NOT_BE_FOUND = Messages.TemplateTypeWizardPage_EXTENSION_POINT_0_COULD_NOT_BE_FOUND;
    private static final long serialVersionUID = -5435162447712125969L;
    private static final String EMPTY_STRING = "";
    private static final String ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION = Messages.TemplateTypeWizardPage_ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION;
    private static final String SELECT_TEMPLATE_TYPE_FORM_THE_LIST = Messages.TemplateTypeWizardPage_SELECT_TEMPLATE_TYPE_FORM_THE_LIST;
    private static final String AVAILABLE_TEMPLATES = Messages.TemplateTypeWizardPage_AVAILABLE_TEMPLATES;
    private static final String TEMPLATE_TYPE_EXTENSION_POINT_ID = "org.eclipse.dirigible.ide.template.type";
    private static final String TEMPLATE_TYPE_ELEMENT_NAME = "template";
    private static final String TEMPLATE_TYPE_TEXT_ATTRIBUTE = "text";
    private static final String TEMPLATE_TYPE_LOCATION_ATTRIBUTE = "location";
    private static final String TEMPLATE_TYPE_IMAGE_ATTRIBUTE = "image";
    private static final String TEMPLATE_TYPE_CATEGORY_ATTRIBUTE = "category";
    private static final String TEMPLATE_TYPE_PARAMETER_ATTRIBUTE = "parameter";
    private static final String TEMPLATE_TYPE_VALUE_ATTRIBUTE = "value";
    private static final Logger logger = Logger.getLogger(TemplateTypeWizardPage.class);
    private TableViewer typeViewer;

    protected TemplateTypeWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract GenerationModel getModel();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTypeField(composite);
        this.checkPageStatus();
    }

    private void createTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(AVAILABLE_TEMPLATES);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.typeViewer = new TableViewer(parent, 2564);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TemplateTypePageLabelProvider());
        TemplateType[] templateTypes = this.createTemplateTypes();
        this.typeViewer.setInput((Object)templateTypes);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() == null || !(selection.getFirstElement() instanceof TemplateType)) {
                    TemplateTypeWizardPage.this.setErrorMessage(SELECT_TEMPLATE_TYPE_FORM_THE_LIST);
                } else {
                    TemplateTypeWizardPage.this.setErrorMessage(null);
                    TemplateType templateType = (TemplateType)selection.getFirstElement();
                    TemplateTypeWizardPage.this.getModel().setTemplate(templateType);
                }
                TemplateTypeWizardPage.this.checkPageStatus();
            }
        });
    }

    private TemplateType[] createTemplateTypes() {
        try {
            TemplateType[] templateTypes = this.prepareTemplateTypes();
            return templateTypes;
        }
        catch (IOException e) {
            logger.error(ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION, (Throwable)e);
            return null;
        }
    }

    private void checkPageStatus() {
        if (this.getModel().getTemplateLocation() == null || EMPTY_STRING.equals(this.getModel().getTemplateLocation())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.getModel().validateTemplate();
        if (status.hasErrors()) {
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(true);
        }
    }

    public List<TemplateTypeDescriptor> getTemplateTypeDescriptors(String category) {
        ArrayList<TemplateTypeDescriptor> templateTypeDescriptors = new ArrayList<TemplateTypeDescriptor>();
        IExtensionPoint extensionPoint = ExtensionPointUtils.getExtensionPoint((String)TEMPLATE_TYPE_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            throw new TemplateTypeException(MessageFormat.format(EXTENSION_POINT_0_COULD_NOT_BE_FOUND, TEMPLATE_TYPE_EXTENSION_POINT_ID));
        }
        IConfigurationElement[] templateTypeDescriptorElements = this.getTemplateElements(extensionPoint.getExtensions());
        int i = 0;
        while (i < templateTypeDescriptorElements.length) {
            TemplateTypeDescriptor templateTypeDescriptor = this.createTemplateTypeDescriptor(category, templateTypeDescriptorElements[i]);
            if (templateTypeDescriptor != null) {
                templateTypeDescriptors.add(templateTypeDescriptor);
            }
            ++i;
        }
        return templateTypeDescriptors;
    }

    private IConfigurationElement[] getTemplateElements(IExtension[] extensions) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (TEMPLATE_TYPE_ELEMENT_NAME.equals(element.getName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    private TemplateTypeDescriptor createTemplateTypeDescriptor(String category, IConfigurationElement templateTypeDescriptorElement) {
        if (category.equals(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_CATEGORY_ATTRIBUTE))) {
            TemplateTypeDescriptor templateTypeDescriptor = new TemplateTypeDescriptor();
            templateTypeDescriptor.setText(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_TEXT_ATTRIBUTE));
            templateTypeDescriptor.setLocation(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_LOCATION_ATTRIBUTE));
            templateTypeDescriptor.setImage(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_IMAGE_ATTRIBUTE));
            HashSet<String> parameters = new HashSet<String>();
            IConfigurationElement[] parameterElements = templateTypeDescriptorElement.getChildren(TEMPLATE_TYPE_PARAMETER_ATTRIBUTE);
            int i = 0;
            while (i < parameterElements.length) {
                parameters.add(parameterElements[i].getAttribute(TEMPLATE_TYPE_VALUE_ATTRIBUTE));
                ++i;
            }
            templateTypeDescriptor.setParameters(parameters);
            return templateTypeDescriptor;
        }
        return null;
    }

    private TemplateType[] prepareTemplateTypes() throws MalformedURLException {
        List<TemplateTypeDescriptor> templateTypeDescriptors = this.getTemplateTypeDescriptors(this.getCategory());
        ArrayList<TemplateType> templateTypesList = new ArrayList<TemplateType>();
        for (TemplateTypeDescriptor templateTypeDescriptor : templateTypeDescriptors) {
            templateTypesList.add(TemplateType.createTemplateType(templateTypeDescriptor.getText(), templateTypeDescriptor.getLocation(), templateTypeDescriptor.getImage(), ((Object)((Object)this)).getClass(), templateTypeDescriptor.getParameters().toArray(new String[0])));
        }
        TemplateType[] templateTypes = templateTypesList.toArray(new TemplateType[0]);
        return templateTypes;
    }

    protected abstract String getCategory();
}

