/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.dual;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.workspace.dual.LocalHttpServletRequest;
import org.eclipse.dirigible.ide.workspace.dual.LocalHttpServletResponse;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;

public class DirectRenderer {
    public static final String SANDBOX_CONTEXT = "sandbox";
    public static final String DEBUG_CONTEXT = "debug";

    public static String renderContent(String location) {
        String message = null;
        try {
            String url = "http://local:0" + location;
            String module = location.substring(1);
            int moduleStart = module.indexOf(47);
            module = module.substring(moduleStart);
            String alias = location.substring(1, moduleStart + 1);
            int dash = alias.indexOf(45);
            if (dash > 0) {
                alias = alias.substring(0, dash);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            LocalHttpServletRequest request = new LocalHttpServletRequest(new URL(url));
            LocalHttpServletResponse response = new LocalHttpServletResponse(baos);
            if (location.contains(SANDBOX_CONTEXT)) {
                request.setAttribute(SANDBOX_CONTEXT, true);
            }
            if (location.contains(DEBUG_CONTEXT)) {
                request.setAttribute(DEBUG_CONTEXT, true);
            }
            HashMap executionContext = new HashMap();
            IScriptExecutor scriptExecutor = EngineUtils.createExecutorByAlias((String)alias, (HttpServletRequest)request);
            scriptExecutor.executeServiceModule((HttpServletRequest)request, (HttpServletResponse)response, module, executionContext);
            response.getWriter().flush();
            response.getOutputStream().flush();
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (MalformedURLException e) {
            message = e.getMessage();
        }
        catch (UnsupportedEncodingException e) {
            message = e.getMessage();
        }
        catch (IOException e) {
            message = e.getMessage();
        }
        return message;
    }
}

