/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizard.file;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.NewFileWizardMainPage;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.NewFileWizardModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewFileWizard
extends Wizard {
    private static final String COULD_NOT_SAVE_FILE = Messages.NewFileWizard_COULD_NOT_SAVE_FILE;
    private static final String OPERATION_FAILED = Messages.NewFileWizard_OPERATION_FAILED;
    private static final String FILE_S_CREATED_SUCCESSFULLY = Messages.NewFileWizard_FILE_S_CREATED_SUCCESSFULLY;
    private static final Logger logger = Logger.getLogger(NewFileWizard.class);
    private static final String WINDOW_TITLE = Messages.NewFileWizard_WINDOW_TITLE;
    private final NewFileWizardMainPage mainPage;
    private final NewFileWizardModel model;

    public NewFileWizard() {
        this(null);
    }

    public NewFileWizard(IContainer selection) {
        this.setWindowTitle(WINDOW_TITLE);
        this.model = new NewFileWizardModel();
        if (selection != null) {
            this.model.setParentLocation(selection.getFullPath().toString());
        }
        this.mainPage = new NewFileWizardMainPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        logger.info(String.format(FILE_S_CREATED_SUCCESSFULLY, this.model.getFileName()));
        boolean result = this.onFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }

    public boolean onFinish() {
        try {
            this.model.execute();
            return true;
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.showErrorDialog(OPERATION_FAILED, COULD_NOT_SAVE_FILE);
            return false;
        }
    }
}

