/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.viewer;

import org.eclipse.dirigible.ide.repository.ui.viewer.AbstractArtifactLabelProvider;
import org.eclipse.dirigible.ide.repository.ui.viewer.RepositoryViewerResolveNode;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.swt.graphics.Image;

public class ArtifactLabelProvider
extends AbstractArtifactLabelProvider {
    private static final long serialVersionUID = 7784009188278209963L;

    public String getText(Object element) {
        if (element instanceof IEntity) {
            return this.getEntityText((IEntity)element);
        }
        if (element instanceof RepositoryViewerResolveNode) {
            return this.getResolveNodeText((RepositoryViewerResolveNode)element);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IEntity) {
            return this.getEntityImage((IEntity)element);
        }
        return null;
    }

    protected String getEntityText(IEntity entity) {
        String name = entity.getName();
        if (name.isEmpty()) {
            return REPOSITORY_ROOT;
        }
        return name;
    }

    protected String getResolveNodeText(RepositoryViewerResolveNode node) {
        return node.getText();
    }

    protected Image getEntityImage(IEntity entity) {
        if (entity instanceof IResource) {
            String resourceName = ((IResource)entity).getName().toLowerCase();
            return this.getResourceImage(resourceName);
        }
        if (entity instanceof ICollection) {
            if (entity.getName().isEmpty()) {
                return this.getRepositoryRootImage((ICollection)entity);
            }
            return this.getCollectionImage((ICollection)entity);
        }
        return this.createImage(TYPE_UNKNOWN_ICON_URL);
    }

    protected Image getCollectionImage(ICollection collection) {
        if (collection != null) {
            String name = collection.getName();
            return this.getCollectionImageByName(name);
        }
        return this.createImage(TYPE_COLLECTION_ICON_URL);
    }

    protected Image getCollectionImageByName(String name) {
        if (name.equals("DataStructures")) {
            return this.createImage(TYPE_COLLECTION_DS_ICON_URL);
        }
        if (name.equals("ExtensionDefinitions")) {
            return this.createImage(TYPE_COLLECTION_EXT_ICON_URL);
        }
        if (name.equals("IntegrationServices")) {
            return this.createImage(TYPE_COLLECTION_IS_ICON_URL);
        }
        if (name.equals("ScriptingServices")) {
            return this.createImage(TYPE_COLLECTION_SS_ICON_URL);
        }
        if (name.equals("SecurityConstraints")) {
            return this.createImage(TYPE_COLLECTION_SEC_ICON_URL);
        }
        if (name.equals("TestCases")) {
            return this.createImage(TYPE_COLLECTION_TEST_ICON_URL);
        }
        if (name.equals("WebContent")) {
            return this.createImage(TYPE_COLLECTION_WEB_ICON_URL);
        }
        if (name.equals("WikiContent")) {
            return this.createImage(TYPE_COLLECTION_WIKI_ICON_URL);
        }
        if (name.equals("MobileApplications")) {
            return this.createImage(TYPE_COLLECTION_MOBILE_ICON_URL);
        }
        return this.createImage(TYPE_COLLECTION_ICON_URL);
    }

    protected Image getRepositoryRootImage(ICollection collection) {
        return this.createImage(TYPE_REPOSITORY_ROOT_ICON_URL);
    }
}

