/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.transfer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.transfer.TableColumn;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBTableExporter {
    private static final String DELIMETER = "|";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String THERE_IS_NO_DATA_IN_TABLE = "There is no data in table ";
    private static final String COULD_NOT_RETRIEVE_TABLE_DATA = "Could not rettrieve table data reason: Table name is null";
    private static final String ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_TABLE = "Error on loading table columns from the Database for Table:";
    private String tableName;
    private String tableType;
    private TableColumn[] tableColumns;
    private static final Logger logger = Logger.getLogger(DBTableExporter.class);
    private DataSource dataSource;

    public DBTableExporter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getTableData() {
        String data = "";
        if (this.getTableName() == null) {
            data = COULD_NOT_RETRIEVE_TABLE_DATA;
            logger.error(COULD_NOT_RETRIEVE_TABLE_DATA);
            return data;
        }
        try {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                ArrayList<TableColumn> availableTableColumns = new ArrayList<TableColumn>();
                ResultSet primaryKeys = DBUtils.getPrimaryKeys(connection, this.getTableName());
                while (primaryKeys.next()) {
                    String columnName = primaryKeys.getString(COLUMN_NAME);
                    TableColumn tableColumn = new TableColumn(columnName, 0, true, true);
                    availableTableColumns.add(tableColumn);
                }
                ResultSet columns = DBUtils.getColumns(connection, this.getTableName());
                while (columns.next()) {
                    int columnType;
                    String columnName = columns.getString(COLUMN_NAME);
                    TableColumn tableColumn = new TableColumn(columnName, columnType = columns.getInt(DATA_TYPE), false, true);
                    if (this.exists(availableTableColumns, tableColumn)) continue;
                    availableTableColumns.add(tableColumn);
                }
                this.setTableColumns(availableTableColumns.toArray(new TableColumn[0]));
                data = this.getDataForTable();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_TABLE + this.getTableName(), (Throwable)e);
        }
        return data;
    }

    private String getDataForTable() {
        String tableName;
        StringBuilder sb;
        String result;
        block20: {
            String sql = null;
            result = null;
            Statement statement = null;
            ResultSet resultSet = null;
            sb = new StringBuilder();
            tableName = this.getTableName();
            TableColumn[] columns = this.getTableColumns();
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                sql = SELECT_FROM + tableName;
                resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    TableColumn[] tableColumnArray = columns;
                    int n = columns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        sb.append(resultSet.getString(column.getName()));
                        sb.append(DELIMETER);
                        ++n2;
                    }
                    sb.deleteCharAt(sb.lastIndexOf(DELIMETER));
                    sb.append("\n");
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException se) {
                logger.error(se.getMessage(), (Throwable)se);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                break block20;
            }
            catch (Exception e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e2) {
                            logger.error(e2.getMessage(), (Throwable)e2);
                        }
                    }
                }
            }
            if (connection == null) break block20;
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((result = sb.toString()).equalsIgnoreCase("")) {
            return THERE_IS_NO_DATA_IN_TABLE + tableName;
        }
        return result;
    }

    private boolean exists(List<TableColumn> availableTableColumns, TableColumn tableColumn) {
        if (this.getTableName() == null) {
            return false;
        }
        for (TableColumn tableColumn2 : availableTableColumns) {
            TableColumn tableColumnX = tableColumn2;
            if (!tableColumnX.getName().equals(tableColumn.getName())) continue;
            tableColumnX.setType(tableColumn.getType());
            return true;
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public TableColumn[] getTableColumns() {
        return this.tableColumns;
    }

    public void setTableColumns(TableColumn[] tableColumns) {
        this.tableColumns = tableColumns;
    }
}

