/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.NamedDataSourcesInitializer;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;

public class DataSourcesInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = 6468050094756163896L;
    private static final Logger logger = Logger.getLogger(DataSourcesInitializerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void registerInitRegister() {
        TaskManagerShort.getInstance().registerRunnableTask((IRunnableTask)new DataSourcesInitializerRegister(this));
        logger.info("Datasources Register has been registered");
    }

    private boolean registerDataSources(HttpServletRequest request) throws ServletException {
        try {
            NamedDataSourcesInitializer namedDataSourcesInitializer = new NamedDataSourcesInitializer();
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            boolean result = namedDataSourcesInitializer.initializeAvailableDataSources(request, repository);
            return result;
        }
        catch (Exception e) {
            throw new ServletException("Initializing local database for Repository use failed", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.registerDataSources(req);
    }

    class DataSourcesInitializerRegister
    implements IRunnableTask {
        DataSourcesInitializerServlet contentInitializerServlet;

        DataSourcesInitializerRegister(DataSourcesInitializerServlet contentInitializerServlet) {
            this.contentInitializerServlet = contentInitializerServlet;
        }

        public String getName() {
            return "Datasources Register";
        }

        public void start() {
            boolean ok = false;
            try {
                ok = DataSourcesInitializerServlet.this.registerDataSources(null);
            }
            catch (ServletException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (ok) {
                TaskManagerShort.getInstance().unregisterRunnableTask((IRunnableTask)this);
                logger.info("Datasources Register has been un-registered");
            }
        }
    }
}

